@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderFoDatabasesAwsOfferingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration for servers Arc auto provisioning
 * @property privateLinkScope Optional Arc private link scope resource id to link the Arc agent
 * @property proxy Optional http proxy endpoint to use for the Arc agent
 */
public data class DefenderFoDatabasesAwsOfferingConfigurationArgs(
    public val privateLinkScope: Output<String>? = null,
    public val proxy: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderFoDatabasesAwsOfferingConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderFoDatabasesAwsOfferingConfigurationArgs =
        com.pulumi.azurenative.security.inputs.DefenderFoDatabasesAwsOfferingConfigurationArgs.builder()
            .privateLinkScope(privateLinkScope?.applyValue({ args0 -> args0 }))
            .proxy(proxy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderFoDatabasesAwsOfferingConfigurationArgs].
 */
@PulumiTagMarker
public class DefenderFoDatabasesAwsOfferingConfigurationArgsBuilder internal constructor() {
    private var privateLinkScope: Output<String>? = null

    private var proxy: Output<String>? = null

    /**
     * @param value Optional Arc private link scope resource id to link the Arc agent
     */
    @JvmName("sbqvqpdggnewlfln")
    public suspend fun privateLinkScope(`value`: Output<String>) {
        this.privateLinkScope = value
    }

    /**
     * @param value Optional http proxy endpoint to use for the Arc agent
     */
    @JvmName("tbfanypnbqdmcjoe")
    public suspend fun proxy(`value`: Output<String>) {
        this.proxy = value
    }

    /**
     * @param value Optional Arc private link scope resource id to link the Arc agent
     */
    @JvmName("myhmdlfoghhtjyoc")
    public suspend fun privateLinkScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkScope = mapped
    }

    /**
     * @param value Optional http proxy endpoint to use for the Arc agent
     */
    @JvmName("dbfadqkqkjycgimm")
    public suspend fun proxy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxy = mapped
    }

    internal fun build(): DefenderFoDatabasesAwsOfferingConfigurationArgs =
        DefenderFoDatabasesAwsOfferingConfigurationArgs(
            privateLinkScope = privateLinkScope,
            proxy = proxy,
        )
}
