@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderFoDatabasesAwsOfferingRdsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The RDS configuration
 * @property cloudRoleArn The cloud role ARN in AWS for this feature
 * @property enabled Is RDS protection enabled
 */
public data class DefenderFoDatabasesAwsOfferingRdsArgs(
    public val cloudRoleArn: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderFoDatabasesAwsOfferingRdsArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderFoDatabasesAwsOfferingRdsArgs =
        com.pulumi.azurenative.security.inputs.DefenderFoDatabasesAwsOfferingRdsArgs.builder()
            .cloudRoleArn(cloudRoleArn?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderFoDatabasesAwsOfferingRdsArgs].
 */
@PulumiTagMarker
public class DefenderFoDatabasesAwsOfferingRdsArgsBuilder internal constructor() {
    private var cloudRoleArn: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value The cloud role ARN in AWS for this feature
     */
    @JvmName("arqveewqkhplfmtp")
    public suspend fun cloudRoleArn(`value`: Output<String>) {
        this.cloudRoleArn = value
    }

    /**
     * @param value Is RDS protection enabled
     */
    @JvmName("elbtqomxmrfxmlxf")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The cloud role ARN in AWS for this feature
     */
    @JvmName("kqfufuxquvnfdbmf")
    public suspend fun cloudRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudRoleArn = mapped
    }

    /**
     * @param value Is RDS protection enabled
     */
    @JvmName("whrceiigbhduqmxu")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DefenderFoDatabasesAwsOfferingRdsArgs =
        DefenderFoDatabasesAwsOfferingRdsArgs(
            cloudRoleArn = cloudRoleArn,
            enabled = enabled,
        )
}
