@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingCloudWatchToKinesisArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The cloudwatch to kinesis connection configuration
 * @property cloudRoleArn The cloud role ARN in AWS used by CloudWatch to transfer data into Kinesis
 */
public data class DefenderForContainersAwsOfferingCloudWatchToKinesisArgs(
    public val cloudRoleArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingCloudWatchToKinesisArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingCloudWatchToKinesisArgs =
        com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingCloudWatchToKinesisArgs.builder()
            .cloudRoleArn(cloudRoleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForContainersAwsOfferingCloudWatchToKinesisArgs].
 */
@PulumiTagMarker
public class DefenderForContainersAwsOfferingCloudWatchToKinesisArgsBuilder internal constructor() {
    private var cloudRoleArn: Output<String>? = null

    /**
     * @param value The cloud role ARN in AWS used by CloudWatch to transfer data into Kinesis
     */
    @JvmName("yxgjmvgbarbjosrb")
    public suspend fun cloudRoleArn(`value`: Output<String>) {
        this.cloudRoleArn = value
    }

    /**
     * @param value The cloud role ARN in AWS used by CloudWatch to transfer data into Kinesis
     */
    @JvmName("akhejvqdgsfnhigq")
    public suspend fun cloudRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudRoleArn = mapped
    }

    internal fun build(): DefenderForContainersAwsOfferingCloudWatchToKinesisArgs =
        DefenderForContainersAwsOfferingCloudWatchToKinesisArgs(
            cloudRoleArn = cloudRoleArn,
        )
}
