@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForContainersGcpOfferingDataPipelineNativeCloudConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The native cloud connection configuration
 * @property serviceAccountEmailAddress The data collection service account email address in GCP for this offering
 * @property workloadIdentityProviderId The data collection GCP workload identity provider id for this offering
 */
public data class DefenderForContainersGcpOfferingDataPipelineNativeCloudConnectionArgs(
    public val serviceAccountEmailAddress: Output<String>? = null,
    public val workloadIdentityProviderId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForContainersGcpOfferingDataPipelineNativeCloudConnectionArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForContainersGcpOfferingDataPipelineNativeCloudConnectionArgs =
        com.pulumi.azurenative.security.inputs.DefenderForContainersGcpOfferingDataPipelineNativeCloudConnectionArgs.builder()
            .serviceAccountEmailAddress(serviceAccountEmailAddress?.applyValue({ args0 -> args0 }))
            .workloadIdentityProviderId(workloadIdentityProviderId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForContainersGcpOfferingDataPipelineNativeCloudConnectionArgs].
 */
@PulumiTagMarker
public class DefenderForContainersGcpOfferingDataPipelineNativeCloudConnectionArgsBuilder internal
constructor() {
    private var serviceAccountEmailAddress: Output<String>? = null

    private var workloadIdentityProviderId: Output<String>? = null

    /**
     * @param value The data collection service account email address in GCP for this offering
     */
    @JvmName("molhdmasfmrdhdyx")
    public suspend fun serviceAccountEmailAddress(`value`: Output<String>) {
        this.serviceAccountEmailAddress = value
    }

    /**
     * @param value The data collection GCP workload identity provider id for this offering
     */
    @JvmName("lqabefcwtlmeuiif")
    public suspend fun workloadIdentityProviderId(`value`: Output<String>) {
        this.workloadIdentityProviderId = value
    }

    /**
     * @param value The data collection service account email address in GCP for this offering
     */
    @JvmName("xowqijnauvfccqbb")
    public suspend fun serviceAccountEmailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccountEmailAddress = mapped
    }

    /**
     * @param value The data collection GCP workload identity provider id for this offering
     */
    @JvmName("mrvqslnebmduktil")
    public suspend fun workloadIdentityProviderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadIdentityProviderId = mapped
    }

    internal fun build(): DefenderForContainersGcpOfferingDataPipelineNativeCloudConnectionArgs =
        DefenderForContainersGcpOfferingDataPipelineNativeCloudConnectionArgs(
            serviceAccountEmailAddress = serviceAccountEmailAddress,
            workloadIdentityProviderId = workloadIdentityProviderId,
        )
}
