@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioningArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The native cloud connection configuration
 * @property serviceAccountEmailAddress The service account email address in GCP for this offering
 * @property workloadIdentityProviderId The GCP workload identity provider id for this offering
 */
public data class DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioningArgs(
    public val serviceAccountEmailAddress: Output<String>? = null,
    public val workloadIdentityProviderId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioningArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioningArgs =
        com.pulumi.azurenative.security.inputs.DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioningArgs.builder()
            .serviceAccountEmailAddress(serviceAccountEmailAddress?.applyValue({ args0 -> args0 }))
            .workloadIdentityProviderId(workloadIdentityProviderId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioningArgs].
 */
@PulumiTagMarker
public class DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioningArgsBuilder
internal constructor() {
    private var serviceAccountEmailAddress: Output<String>? = null

    private var workloadIdentityProviderId: Output<String>? = null

    /**
     * @param value The service account email address in GCP for this offering
     */
    @JvmName("nbeitvvybdrdpsjq")
    public suspend fun serviceAccountEmailAddress(`value`: Output<String>) {
        this.serviceAccountEmailAddress = value
    }

    /**
     * @param value The GCP workload identity provider id for this offering
     */
    @JvmName("ektnmfmibxschrwd")
    public suspend fun workloadIdentityProviderId(`value`: Output<String>) {
        this.workloadIdentityProviderId = value
    }

    /**
     * @param value The service account email address in GCP for this offering
     */
    @JvmName("lwklewhwkkukfnak")
    public suspend fun serviceAccountEmailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccountEmailAddress = mapped
    }

    /**
     * @param value The GCP workload identity provider id for this offering
     */
    @JvmName("amvxvlausrrbgxka")
    public suspend fun workloadIdentityProviderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadIdentityProviderId = mapped
    }

    internal fun build(): DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioningArgs =
        DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioningArgs(
            serviceAccountEmailAddress = serviceAccountEmailAddress,
            workloadIdentityProviderId = workloadIdentityProviderId,
        )
}
