@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingConfigurationConfigurationArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.Type
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * configuration for Vulnerability Assessment autoprovisioning
 * @property type The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
 */
public data class DefenderForServersAwsOfferingConfigurationConfigurationArgs(
    public val type: Output<Either<String, Type>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingConfigurationConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingConfigurationConfigurationArgs =
        com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingConfigurationConfigurationArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DefenderForServersAwsOfferingConfigurationConfigurationArgs].
 */
@PulumiTagMarker
public class DefenderForServersAwsOfferingConfigurationConfigurationArgsBuilder internal
constructor() {
    private var type: Output<Either<String, Type>>? = null

    /**
     * @param value The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
     */
    @JvmName("gghmvmqtxvqkuseb")
    public suspend fun type(`value`: Output<Either<String, Type>>) {
        this.type = value
    }

    /**
     * @param value The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
     */
    @JvmName("wdcprimsxmcidjmw")
    public suspend fun type(`value`: Either<String, Type>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
     */
    @JvmName("anrfcgjbkhvcwjxk")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
     */
    @JvmName("ufpclfsotcfvsxry")
    public fun type(`value`: Type) {
        val toBeMapped = Either.ofRight<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DefenderForServersAwsOfferingConfigurationConfigurationArgs =
        DefenderForServersAwsOfferingConfigurationConfigurationArgs(
            type = type,
        )
}
