@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingMdeAutoProvisioningArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Microsoft Defender for Endpoint autoprovisioning configuration
 * @property configuration configuration for Microsoft Defender for Endpoint autoprovisioning
 * @property enabled Is Microsoft Defender for Endpoint auto provisioning enabled
 */
public data class DefenderForServersAwsOfferingMdeAutoProvisioningArgs(
    public val configuration: Output<Any>? = null,
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingMdeAutoProvisioningArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingMdeAutoProvisioningArgs =
        com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingMdeAutoProvisioningArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForServersAwsOfferingMdeAutoProvisioningArgs].
 */
@PulumiTagMarker
public class DefenderForServersAwsOfferingMdeAutoProvisioningArgsBuilder internal constructor() {
    private var configuration: Output<Any>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value configuration for Microsoft Defender for Endpoint autoprovisioning
     */
    @JvmName("umgoadxmhdqknvbq")
    public suspend fun configuration(`value`: Output<Any>) {
        this.configuration = value
    }

    /**
     * @param value Is Microsoft Defender for Endpoint auto provisioning enabled
     */
    @JvmName("tijbpoyrvdbtqmjk")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value configuration for Microsoft Defender for Endpoint autoprovisioning
     */
    @JvmName("brhplabxwvxhkpmd")
    public suspend fun configuration(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param value Is Microsoft Defender for Endpoint auto provisioning enabled
     */
    @JvmName("xpwdthsypaxqlkyt")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DefenderForServersAwsOfferingMdeAutoProvisioningArgs =
        DefenderForServersAwsOfferingMdeAutoProvisioningArgs(
            configuration = configuration,
            enabled = enabled,
        )
}
