@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingConfigurationConfigurationConfigurationArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.ScanningMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * configuration for Microsoft Defender for Server VM scanning
 * @property exclusionTags VM tags that indicate that VM should not be scanned
 * @property scanningMode The scanning mode for the VM scan.
 */
public data class DefenderForServersGcpOfferingConfigurationConfigurationConfigurationArgs(
    public val exclusionTags: Output<Map<String, String>>? = null,
    public val scanningMode: Output<Either<String, ScanningMode>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingConfigurationConfigurationConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingConfigurationConfigurationConfigurationArgs =
        com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingConfigurationConfigurationConfigurationArgs.builder()
            .exclusionTags(
                exclusionTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .scanningMode(
                scanningMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DefenderForServersGcpOfferingConfigurationConfigurationConfigurationArgs].
 */
@PulumiTagMarker
public class DefenderForServersGcpOfferingConfigurationConfigurationConfigurationArgsBuilder
internal constructor() {
    private var exclusionTags: Output<Map<String, String>>? = null

    private var scanningMode: Output<Either<String, ScanningMode>>? = null

    /**
     * @param value VM tags that indicate that VM should not be scanned
     */
    @JvmName("brnqwrpnbnbxfpgw")
    public suspend fun exclusionTags(`value`: Output<Map<String, String>>) {
        this.exclusionTags = value
    }

    /**
     * @param value The scanning mode for the VM scan.
     */
    @JvmName("kxmjnxppbrlrsamt")
    public suspend fun scanningMode(`value`: Output<Either<String, ScanningMode>>) {
        this.scanningMode = value
    }

    /**
     * @param value VM tags that indicate that VM should not be scanned
     */
    @JvmName("pgtvkcfpstjqlqfl")
    public suspend fun exclusionTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusionTags = mapped
    }

    /**
     * @param values VM tags that indicate that VM should not be scanned
     */
    @JvmName("bvbwvvfccpydjoic")
    public fun exclusionTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exclusionTags = mapped
    }

    /**
     * @param value The scanning mode for the VM scan.
     */
    @JvmName("acustktkwnrxvkya")
    public suspend fun scanningMode(`value`: Either<String, ScanningMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanningMode = mapped
    }

    /**
     * @param value The scanning mode for the VM scan.
     */
    @JvmName("tgklwtkivnpqkvtr")
    public fun scanningMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScanningMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scanningMode = mapped
    }

    /**
     * @param value The scanning mode for the VM scan.
     */
    @JvmName("oqjsdryplmopfknu")
    public fun scanningMode(`value`: ScanningMode) {
        val toBeMapped = Either.ofRight<String, ScanningMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scanningMode = mapped
    }

    internal fun build(): DefenderForServersGcpOfferingConfigurationConfigurationConfigurationArgs =
        DefenderForServersGcpOfferingConfigurationConfigurationConfigurationArgs(
            exclusionTags = exclusionTags,
            scanningMode = scanningMode,
        )
}
