@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetApplicationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationId The security Application key - unique key for the standard application
 */
public data class GetApplicationPlainArgs(
    public val applicationId: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetApplicationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetApplicationPlainArgs =
        com.pulumi.azurenative.security.inputs.GetApplicationPlainArgs.builder()
            .applicationId(applicationId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationPlainArgsBuilder internal constructor() {
    private var applicationId: String? = null

    /**
     * @param value The security Application key - unique key for the standard application
     */
    @JvmName("ektchbuqkwokpvmg")
    public suspend fun applicationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationId = mapped
    }

    internal fun build(): GetApplicationPlainArgs = GetApplicationPlainArgs(
        applicationId = applicationId ?: throw PulumiNullFieldException("applicationId"),
    )
}
