@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetAssessmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property assessmentName The Assessment Key - Unique key for the assessment type
 * @property expand OData expand. Optional.
 * @property resourceId The identifier of the resource.
 */
public data class GetAssessmentPlainArgs(
    public val assessmentName: String,
    public val expand: String? = null,
    public val resourceId: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetAssessmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetAssessmentPlainArgs =
        com.pulumi.azurenative.security.inputs.GetAssessmentPlainArgs.builder()
            .assessmentName(assessmentName.let({ args0 -> args0 }))
            .expand(expand?.let({ args0 -> args0 }))
            .resourceId(resourceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAssessmentPlainArgs].
 */
@PulumiTagMarker
public class GetAssessmentPlainArgsBuilder internal constructor() {
    private var assessmentName: String? = null

    private var expand: String? = null

    private var resourceId: String? = null

    /**
     * @param value The Assessment Key - Unique key for the assessment type
     */
    @JvmName("ycrfdohppnbuknnc")
    public suspend fun assessmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assessmentName = mapped
    }

    /**
     * @param value OData expand. Optional.
     */
    @JvmName("dwkbygmofcgyyvrr")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("shohshcbomhjwxme")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceId = mapped
    }

    internal fun build(): GetAssessmentPlainArgs = GetAssessmentPlainArgs(
        assessmentName = assessmentName ?: throw PulumiNullFieldException("assessmentName"),
        expand = expand,
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
    )
}
