@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property assignmentId The security assignment key - unique key for the standard assignment
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class GetAssignmentPlainArgs(
    public val assignmentId: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetAssignmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetAssignmentPlainArgs =
        com.pulumi.azurenative.security.inputs.GetAssignmentPlainArgs.builder()
            .assignmentId(assignmentId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetAssignmentPlainArgsBuilder internal constructor() {
    private var assignmentId: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The security assignment key - unique key for the standard assignment
     */
    @JvmName("krlfgwydbixsxect")
    public suspend fun assignmentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assignmentId = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("fqtrcwgeubyxiwec")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAssignmentPlainArgs = GetAssignmentPlainArgs(
        assignmentId = assignmentId ?: throw PulumiNullFieldException("assignmentId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
