@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetGovernanceRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ruleId The governance rule key - unique key for the standard governance rule (GUID)
 * @property scope The scope of the Governance rules. Valid scopes are: management group (format: 'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: 'subscriptions/{subscriptionId}'), or security connector (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
 */
public data class GetGovernanceRulePlainArgs(
    public val ruleId: String,
    public val scope: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetGovernanceRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetGovernanceRulePlainArgs =
        com.pulumi.azurenative.security.inputs.GetGovernanceRulePlainArgs.builder()
            .ruleId(ruleId.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGovernanceRulePlainArgs].
 */
@PulumiTagMarker
public class GetGovernanceRulePlainArgsBuilder internal constructor() {
    private var ruleId: String? = null

    private var scope: String? = null

    /**
     * @param value The governance rule key - unique key for the standard governance rule (GUID)
     */
    @JvmName("xebakxfpdandhqkw")
    public suspend fun ruleId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleId = mapped
    }

    /**
     * @param value The scope of the Governance rules. Valid scopes are: management group (format: 'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: 'subscriptions/{subscriptionId}'), or security connector (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
     */
    @JvmName("dxytxfjrrrikevbw")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetGovernanceRulePlainArgs = GetGovernanceRulePlainArgs(
        ruleId = ruleId ?: throw PulumiNullFieldException("ruleId"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
