@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetSecurityContactPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property securityContactName Name of the security contact object
 */
public data class GetSecurityContactPlainArgs(
    public val securityContactName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetSecurityContactPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetSecurityContactPlainArgs =
        com.pulumi.azurenative.security.inputs.GetSecurityContactPlainArgs.builder()
            .securityContactName(securityContactName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecurityContactPlainArgs].
 */
@PulumiTagMarker
public class GetSecurityContactPlainArgsBuilder internal constructor() {
    private var securityContactName: String? = null

    /**
     * @param value Name of the security contact object
     */
    @JvmName("pjefxgwatyyqwujq")
    public suspend fun securityContactName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityContactName = mapped
    }

    internal fun build(): GetSecurityContactPlainArgs = GetSecurityContactPlainArgs(
        securityContactName = securityContactName ?: throw PulumiNullFieldException("securityContactName"),
    )
}
