@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GovernanceAssignmentAdditionalDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describe the additional data of governance assignment - optional
 * @property ticketLink Ticket link associated with this governance assignment - for example: https://snow.com
 * @property ticketNumber Ticket number associated with this governance assignment
 * @property ticketStatus The ticket status associated with this governance assignment - for example: Active
 */
public data class GovernanceAssignmentAdditionalDataArgs(
    public val ticketLink: Output<String>? = null,
    public val ticketNumber: Output<Int>? = null,
    public val ticketStatus: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GovernanceAssignmentAdditionalDataArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.GovernanceAssignmentAdditionalDataArgs =
        com.pulumi.azurenative.security.inputs.GovernanceAssignmentAdditionalDataArgs.builder()
            .ticketLink(ticketLink?.applyValue({ args0 -> args0 }))
            .ticketNumber(ticketNumber?.applyValue({ args0 -> args0 }))
            .ticketStatus(ticketStatus?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GovernanceAssignmentAdditionalDataArgs].
 */
@PulumiTagMarker
public class GovernanceAssignmentAdditionalDataArgsBuilder internal constructor() {
    private var ticketLink: Output<String>? = null

    private var ticketNumber: Output<Int>? = null

    private var ticketStatus: Output<String>? = null

    /**
     * @param value Ticket link associated with this governance assignment - for example: https://snow.com
     */
    @JvmName("bdtbwmrohaxfpyyn")
    public suspend fun ticketLink(`value`: Output<String>) {
        this.ticketLink = value
    }

    /**
     * @param value Ticket number associated with this governance assignment
     */
    @JvmName("bbimsqjwpnhohqsb")
    public suspend fun ticketNumber(`value`: Output<Int>) {
        this.ticketNumber = value
    }

    /**
     * @param value The ticket status associated with this governance assignment - for example: Active
     */
    @JvmName("leygjhhjsscqaruk")
    public suspend fun ticketStatus(`value`: Output<String>) {
        this.ticketStatus = value
    }

    /**
     * @param value Ticket link associated with this governance assignment - for example: https://snow.com
     */
    @JvmName("ldpcqmlsspoqafgp")
    public suspend fun ticketLink(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ticketLink = mapped
    }

    /**
     * @param value Ticket number associated with this governance assignment
     */
    @JvmName("qcpkxlobfsfcrvyn")
    public suspend fun ticketNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ticketNumber = mapped
    }

    /**
     * @param value The ticket status associated with this governance assignment - for example: Active
     */
    @JvmName("bblwwxxihqseraws")
    public suspend fun ticketStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ticketStatus = mapped
    }

    internal fun build(): GovernanceAssignmentAdditionalDataArgs =
        GovernanceAssignmentAdditionalDataArgs(
            ticketLink = ticketLink,
            ticketNumber = ticketNumber,
            ticketStatus = ticketStatus,
        )
}
