@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.HybridComputeSettingsPropertiesArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.AutoProvision
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Settings for hybrid compute management
 * @property autoProvision Whether or not to automatically install Azure Arc (hybrid compute) agents on machines
 * @property proxyServer For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.
 * @property region The location where the metadata of machines will be stored
 * @property resourceGroupName The name of the resource group where Arc (Hybrid Compute) connectors are connected.
 * @property servicePrincipal An object to access resources that are secured by an Azure AD tenant.
 */
public data class HybridComputeSettingsPropertiesArgs(
    public val autoProvision: Output<Either<String, AutoProvision>>,
    public val proxyServer: Output<ProxyServerPropertiesArgs>? = null,
    public val region: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val servicePrincipal: Output<ServicePrincipalPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.HybridComputeSettingsPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.HybridComputeSettingsPropertiesArgs =
        com.pulumi.azurenative.security.inputs.HybridComputeSettingsPropertiesArgs.builder()
            .autoProvision(
                autoProvision.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .proxyServer(proxyServer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .region(region?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .servicePrincipal(
                servicePrincipal?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [HybridComputeSettingsPropertiesArgs].
 */
@PulumiTagMarker
public class HybridComputeSettingsPropertiesArgsBuilder internal constructor() {
    private var autoProvision: Output<Either<String, AutoProvision>>? = null

    private var proxyServer: Output<ProxyServerPropertiesArgs>? = null

    private var region: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var servicePrincipal: Output<ServicePrincipalPropertiesArgs>? = null

    /**
     * @param value Whether or not to automatically install Azure Arc (hybrid compute) agents on machines
     */
    @JvmName("miryktvjhiwmkqvp")
    public suspend fun autoProvision(`value`: Output<Either<String, AutoProvision>>) {
        this.autoProvision = value
    }

    /**
     * @param value For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.
     */
    @JvmName("nhljpgnfwdrkpilh")
    public suspend fun proxyServer(`value`: Output<ProxyServerPropertiesArgs>) {
        this.proxyServer = value
    }

    /**
     * @param value The location where the metadata of machines will be stored
     */
    @JvmName("mvhbsrrdcmexvlcn")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value The name of the resource group where Arc (Hybrid Compute) connectors are connected.
     */
    @JvmName("ojcsryekgogucfcj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value An object to access resources that are secured by an Azure AD tenant.
     */
    @JvmName("mybbxuvgmwdexdsw")
    public suspend fun servicePrincipal(`value`: Output<ServicePrincipalPropertiesArgs>) {
        this.servicePrincipal = value
    }

    /**
     * @param value Whether or not to automatically install Azure Arc (hybrid compute) agents on machines
     */
    @JvmName("bkrrhygrsexhucws")
    public suspend fun autoProvision(`value`: Either<String, AutoProvision>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoProvision = mapped
    }

    /**
     * @param value Whether or not to automatically install Azure Arc (hybrid compute) agents on machines
     */
    @JvmName("svlpldfftdbmqvml")
    public fun autoProvision(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutoProvision>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoProvision = mapped
    }

    /**
     * @param value Whether or not to automatically install Azure Arc (hybrid compute) agents on machines
     */
    @JvmName("vwndaljlosooxafn")
    public fun autoProvision(`value`: AutoProvision) {
        val toBeMapped = Either.ofRight<String, AutoProvision>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoProvision = mapped
    }

    /**
     * @param value For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.
     */
    @JvmName("cfprlfohngsqpjns")
    public suspend fun proxyServer(`value`: ProxyServerPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyServer = mapped
    }

    /**
     * @param argument For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.
     */
    @JvmName("kydomjhvbxweepgc")
    public suspend fun proxyServer(argument: suspend ProxyServerPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ProxyServerPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.proxyServer = mapped
    }

    /**
     * @param value The location where the metadata of machines will be stored
     */
    @JvmName("tiqqkbdhmyphtkrd")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value The name of the resource group where Arc (Hybrid Compute) connectors are connected.
     */
    @JvmName("saymhgokdiidgesa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value An object to access resources that are secured by an Azure AD tenant.
     */
    @JvmName("xlykekoiuercysxh")
    public suspend fun servicePrincipal(`value`: ServicePrincipalPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipal = mapped
    }

    /**
     * @param argument An object to access resources that are secured by an Azure AD tenant.
     */
    @JvmName("jysxytxkfpuhuhuj")
    public suspend
    fun servicePrincipal(argument: suspend ServicePrincipalPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ServicePrincipalPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.servicePrincipal = mapped
    }

    internal fun build(): HybridComputeSettingsPropertiesArgs = HybridComputeSettingsPropertiesArgs(
        autoProvision = autoProvision ?: throw PulumiNullFieldException("autoProvision"),
        proxyServer = proxyServer,
        region = region,
        resourceGroupName = resourceGroupName,
        servicePrincipal = servicePrincipal,
    )
}
