@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.SecurityAssessmentMetadataPartnerDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the partner that created the assessment
 * @property partnerName Name of the company of the partner
 * @property productName Name of the product of the partner that created the assessment
 * @property secret Secret to authenticate the partner and verify it created the assessment - write only
 */
public data class SecurityAssessmentMetadataPartnerDataArgs(
    public val partnerName: Output<String>,
    public val productName: Output<String>? = null,
    public val secret: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.SecurityAssessmentMetadataPartnerDataArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.SecurityAssessmentMetadataPartnerDataArgs =
        com.pulumi.azurenative.security.inputs.SecurityAssessmentMetadataPartnerDataArgs.builder()
            .partnerName(partnerName.applyValue({ args0 -> args0 }))
            .productName(productName?.applyValue({ args0 -> args0 }))
            .secret(secret.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityAssessmentMetadataPartnerDataArgs].
 */
@PulumiTagMarker
public class SecurityAssessmentMetadataPartnerDataArgsBuilder internal constructor() {
    private var partnerName: Output<String>? = null

    private var productName: Output<String>? = null

    private var secret: Output<String>? = null

    /**
     * @param value Name of the company of the partner
     */
    @JvmName("agnmrxtadfuqxibp")
    public suspend fun partnerName(`value`: Output<String>) {
        this.partnerName = value
    }

    /**
     * @param value Name of the product of the partner that created the assessment
     */
    @JvmName("dtlkwgabqywjkjth")
    public suspend fun productName(`value`: Output<String>) {
        this.productName = value
    }

    /**
     * @param value Secret to authenticate the partner and verify it created the assessment - write only
     */
    @JvmName("mmixyevxubmrokcy")
    public suspend fun secret(`value`: Output<String>) {
        this.secret = value
    }

    /**
     * @param value Name of the company of the partner
     */
    @JvmName("gafvhsfxltgtvslk")
    public suspend fun partnerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partnerName = mapped
    }

    /**
     * @param value Name of the product of the partner that created the assessment
     */
    @JvmName("xisegmsfblnjtots")
    public suspend fun productName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productName = mapped
    }

    /**
     * @param value Secret to authenticate the partner and verify it created the assessment - write only
     */
    @JvmName("tdvbtdprblysjpxr")
    public suspend fun secret(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secret = mapped
    }

    internal fun build(): SecurityAssessmentMetadataPartnerDataArgs =
        SecurityAssessmentMetadataPartnerDataArgs(
            partnerName = partnerName ?: throw PulumiNullFieldException("partnerName"),
            productName = productName,
            secret = secret ?: throw PulumiNullFieldException("secret"),
        )
}
