@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.SuppressionAlertsScopeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allOf All the conditions inside need to be true in order to suppress the alert
 */
public data class SuppressionAlertsScopeArgs(
    public val allOf: Output<List<ScopeElementArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.SuppressionAlertsScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.SuppressionAlertsScopeArgs =
        com.pulumi.azurenative.security.inputs.SuppressionAlertsScopeArgs.builder()
            .allOf(
                allOf.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SuppressionAlertsScopeArgs].
 */
@PulumiTagMarker
public class SuppressionAlertsScopeArgsBuilder internal constructor() {
    private var allOf: Output<List<ScopeElementArgs>>? = null

    /**
     * @param value All the conditions inside need to be true in order to suppress the alert
     */
    @JvmName("dmpxklufmlqwhgsx")
    public suspend fun allOf(`value`: Output<List<ScopeElementArgs>>) {
        this.allOf = value
    }

    @JvmName("dxethhkujprmtiqt")
    public suspend fun allOf(vararg values: Output<ScopeElementArgs>) {
        this.allOf = Output.all(values.asList())
    }

    /**
     * @param values All the conditions inside need to be true in order to suppress the alert
     */
    @JvmName("mddodeluvsqechgm")
    public suspend fun allOf(values: List<Output<ScopeElementArgs>>) {
        this.allOf = Output.all(values)
    }

    /**
     * @param value All the conditions inside need to be true in order to suppress the alert
     */
    @JvmName("nqfwbiagbsnwyqjw")
    public suspend fun allOf(`value`: List<ScopeElementArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allOf = mapped
    }

    /**
     * @param argument All the conditions inside need to be true in order to suppress the alert
     */
    @JvmName("mpurqqudfgxhdyus")
    public suspend fun allOf(argument: List<suspend ScopeElementArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScopeElementArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.allOf = mapped
    }

    /**
     * @param argument All the conditions inside need to be true in order to suppress the alert
     */
    @JvmName("vovxknmqkiwmwbvy")
    public suspend fun allOf(vararg argument: suspend ScopeElementArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScopeElementArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.allOf = mapped
    }

    /**
     * @param argument All the conditions inside need to be true in order to suppress the alert
     */
    @JvmName("nlbetvbwxcqwpicg")
    public suspend fun allOf(argument: suspend ScopeElementArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScopeElementArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.allOf = mapped
    }

    /**
     * @param values All the conditions inside need to be true in order to suppress the alert
     */
    @JvmName("llvkjsyqayghbnhr")
    public suspend fun allOf(vararg values: ScopeElementArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allOf = mapped
    }

    internal fun build(): SuppressionAlertsScopeArgs = SuppressionAlertsScopeArgs(
        allOf = allOf ?: throw PulumiNullFieldException("allOf"),
    )
}
