@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of the additional workspaces.
 * @property dataTypes List of data types sent to workspace
 * @property type Workspace type.
 * @property workspace Workspace resource id
 */
public data class AdditionalWorkspacesPropertiesResponse(
    public val dataTypes: List<String>? = null,
    public val type: String? = null,
    public val workspace: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AdditionalWorkspacesPropertiesResponse):
            AdditionalWorkspacesPropertiesResponse = AdditionalWorkspacesPropertiesResponse(
            dataTypes = javaType.dataTypes().map({ args0 -> args0 }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            workspace = javaType.workspace().map({ args0 -> args0 }).orElse(null),
        )
    }
}
