@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A rule which is evaluated upon event interception. The rule is configured by comparing a specific value from the event model to an expected value. This comparison is done by using one of the supported operators set.
 * @property expectedValue The expected value.
 * @property operator A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType.
 * @property propertyJPath The JPath of the entity model property that should be checked.
 * @property propertyType The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]
 */
public data class AutomationTriggeringRuleResponse(
    public val expectedValue: String? = null,
    public val `operator`: String? = null,
    public val propertyJPath: String? = null,
    public val propertyType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AutomationTriggeringRuleResponse):
            AutomationTriggeringRuleResponse = AutomationTriggeringRuleResponse(
            expectedValue = javaType.expectedValue().map({ args0 -> args0 }).orElse(null),
            `operator` = javaType.`operator`().map({ args0 -> args0 }).orElse(null),
            propertyJPath = javaType.propertyJPath().map({ args0 -> args0 }).orElse(null),
            propertyType = javaType.propertyType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
