@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Severity level per category configuration for PR Annotations.
 * @property category Rule categories.
 * Code - code scanning results.
 * Artifact scanning results.
 * Dependencies scanning results.
 * IaC results.
 * Secrets scanning results.
 * Container scanning results.
 * @property minimumSeverityLevel Gets or sets minimum severity level for a given category.
 */
public data class CategoryConfigurationResponse(
    public val category: String? = null,
    public val minimumSeverityLevel: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.CategoryConfigurationResponse):
            CategoryConfigurationResponse = CategoryConfigurationResponse(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            minimumSeverityLevel = javaType.minimumSeverityLevel().map({ args0 -> args0 }).orElse(null),
        )
    }
}
