@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * configuration for Microsoft Defender for Server VM scanning
 * @property cloudRoleArn The cloud role ARN in AWS for this feature
 * @property exclusionTags VM tags that indicates that VM should not be scanned
 * @property scanningMode The scanning mode for the VM scan.
 */
public data class DefenderCspmAwsOfferingResponseConfiguration(
    public val cloudRoleArn: String? = null,
    public val exclusionTags: Map<String, String>? = null,
    public val scanningMode: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderCspmAwsOfferingResponseConfiguration):
            DefenderCspmAwsOfferingResponseConfiguration = DefenderCspmAwsOfferingResponseConfiguration(
            cloudRoleArn = javaType.cloudRoleArn().map({ args0 -> args0 }).orElse(null),
            exclusionTags = javaType.exclusionTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            scanningMode = javaType.scanningMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
