@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The cloudwatch to kinesis connection configuration
 * @property cloudRoleArn The cloud role ARN in AWS used by CloudWatch to transfer data into Kinesis
 */
public data class DefenderForContainersAwsOfferingResponseCloudWatchToKinesis(
    public val cloudRoleArn: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForContainersAwsOfferingResponseCloudWatchToKinesis):
            DefenderForContainersAwsOfferingResponseCloudWatchToKinesis =
            DefenderForContainersAwsOfferingResponseCloudWatchToKinesis(
                cloudRoleArn = javaType.cloudRoleArn().map({ args0 -> args0 }).orElse(null),
            )
    }
}
