@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The native cloud connection configuration
 * @property serviceAccountEmailAddress The data collection service account email address in GCP for this offering
 * @property workloadIdentityProviderId The data collection GCP workload identity provider id for this offering
 */
public data class DefenderForContainersGcpOfferingResponseDataPipelineNativeCloudConnection(
    public val serviceAccountEmailAddress: String? = null,
    public val workloadIdentityProviderId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForContainersGcpOfferingResponseDataPipelineNativeCloudConnection):
            DefenderForContainersGcpOfferingResponseDataPipelineNativeCloudConnection =
            DefenderForContainersGcpOfferingResponseDataPipelineNativeCloudConnection(
                serviceAccountEmailAddress = javaType.serviceAccountEmailAddress().map({ args0 ->
                    args0
                }).orElse(null),
                workloadIdentityProviderId = javaType.workloadIdentityProviderId().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
