@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The ARC autoprovisioning configuration
 * @property cloudRoleArn The cloud role ARN in AWS for this feature
 * @property configuration Configuration for servers Arc auto provisioning
 * @property enabled Is arc auto provisioning enabled
 */
public data class DefenderForServersAwsOfferingResponseArcAutoProvisioning(
    public val cloudRoleArn: String? = null,
    public val configuration: DefenderForServersAwsOfferingResponseConfiguration? = null,
    public val enabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForServersAwsOfferingResponseArcAutoProvisioning):
            DefenderForServersAwsOfferingResponseArcAutoProvisioning =
            DefenderForServersAwsOfferingResponseArcAutoProvisioning(
                cloudRoleArn = javaType.cloudRoleArn().map({ args0 -> args0 }).orElse(null),
                configuration = javaType.configuration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.security.kotlin.outputs.DefenderForServersAwsOfferingResponseConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
