@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.Suppress

/**
 * The Microsoft Defender for Endpoint autoprovisioning configuration
 * @property configuration configuration for Microsoft Defender for Endpoint autoprovisioning
 * @property enabled Is Microsoft Defender for Endpoint auto provisioning enabled
 */
public data class DefenderForServersAwsOfferingResponseMdeAutoProvisioning(
    public val configuration: Any? = null,
    public val enabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForServersAwsOfferingResponseMdeAutoProvisioning):
            DefenderForServersAwsOfferingResponseMdeAutoProvisioning =
            DefenderForServersAwsOfferingResponseMdeAutoProvisioning(
                configuration = javaType.configuration().map({ args0 -> args0 }).orElse(null),
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
