@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration for servers Arc auto provisioning
 * @property privateLinkScope Optional Arc private link scope resource id to link the Arc agent
 * @property proxy Optional HTTP proxy endpoint to use for the Arc agent
 */
public data class DefenderForServersGcpOfferingResponseConfiguration(
    public val privateLinkScope: String? = null,
    public val proxy: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForServersGcpOfferingResponseConfiguration):
            DefenderForServersGcpOfferingResponseConfiguration =
            DefenderForServersGcpOfferingResponseConfiguration(
                privateLinkScope = javaType.privateLinkScope().map({ args0 -> args0 }).orElse(null),
                proxy = javaType.proxy().map({ args0 -> args0 }).orElse(null),
            )
    }
}
