@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * The GCP project connector environment data
 * @property environmentType The type of the environment data.
 * Expected value is 'GcpProject'.
 * @property organizationalData The Gcp project's organizational data
 * @property projectDetails The Gcp project's details
 */
public data class GcpProjectEnvironmentDataResponse(
    public val environmentType: String,
    public val organizationalData:
    Either<GcpOrganizationalDataMemberResponse, GcpOrganizationalDataOrganizationResponse>? =
        null,
    public val projectDetails: GcpProjectDetailsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GcpProjectEnvironmentDataResponse):
            GcpProjectEnvironmentDataResponse = GcpProjectEnvironmentDataResponse(
            environmentType = javaType.environmentType(),
            organizationalData = javaType.organizationalData().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.security.kotlin.outputs.GcpOrganizationalDataMemberResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.security.kotlin.outputs.GcpOrganizationalDataOrganizationResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            projectDetails = javaType.projectDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.GcpProjectDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
