@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An API collection as represented by Defender for APIs.
 * @property additionalData Additional data regarding the API collection.
 * @property displayName The display name of the Azure API Management API.
 * @property id Resource Id
 * @property name Resource name
 * @property type Resource type
 */
public data class GetAPICollectionResult(
    public val additionalData: Map<String, String>? = null,
    public val displayName: String? = null,
    public val id: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetAPICollectionResult):
            GetAPICollectionResult = GetAPICollectionResult(
            additionalData = javaType.additionalData().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
