@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property configurationStatus The configuration status of the machines group or machine or rule
 * @property enforcementMode The application control policy enforcement/protection mode of the machine group
 * @property id Resource Id
 * @property issues
 * @property location Location where the resource is stored
 * @property name Resource name
 * @property pathRecommendations
 * @property protectionMode The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
 * @property recommendationStatus The initial recommendation status of the machine group or machine
 * @property sourceSystem The source type of the machine group
 * @property type Resource type
 * @property vmRecommendations
 */
public data class GetAdaptiveApplicationControlResult(
    public val configurationStatus: String,
    public val enforcementMode: String? = null,
    public val id: String,
    public val issues: List<AdaptiveApplicationControlIssueSummaryResponse>,
    public val location: String,
    public val name: String,
    public val pathRecommendations: List<PathRecommendationResponse>? = null,
    public val protectionMode: ProtectionModeResponse? = null,
    public val recommendationStatus: String,
    public val sourceSystem: String,
    public val type: String,
    public val vmRecommendations: List<VmRecommendationResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetAdaptiveApplicationControlResult):
            GetAdaptiveApplicationControlResult = GetAdaptiveApplicationControlResult(
            configurationStatus = javaType.configurationStatus(),
            enforcementMode = javaType.enforcementMode().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            issues = javaType.issues().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.AdaptiveApplicationControlIssueSummaryResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            name = javaType.name(),
            pathRecommendations = javaType.pathRecommendations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.PathRecommendationResponse.Companion.toKotlin(args0)
                })
            }),
            protectionMode = javaType.protectionMode().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.ProtectionModeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            recommendationStatus = javaType.recommendationStatus(),
            sourceSystem = javaType.sourceSystem(),
            type = javaType.type(),
            vmRecommendations = javaType.vmRecommendations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.VmRecommendationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
