@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Custom Assessment Automation
 * @property assessmentKey The assessment metadata key used when an assessment is generated for this assessment automation.
 * @property compressedQuery GZip encoded KQL query representing the assessment automation results required.
 * @property description The description to relate to the assessments generated by this assessment automation.
 * @property displayName The display name of the assessments generated by this assessment automation.
 * @property id Resource Id
 * @property name Resource name
 * @property remediationDescription The remediation description to relate to the assessments generated by this assessment automation.
 * @property severity The severity to relate to the assessments generated by this assessment automation.
 * @property supportedCloud Relevant cloud for the custom assessment automation.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type Resource type
 */
public data class GetCustomAssessmentAutomationResult(
    public val assessmentKey: String? = null,
    public val compressedQuery: String? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val name: String,
    public val remediationDescription: String? = null,
    public val severity: String? = null,
    public val supportedCloud: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetCustomAssessmentAutomationResult):
            GetCustomAssessmentAutomationResult = GetCustomAssessmentAutomationResult(
            assessmentKey = javaType.assessmentKey().map({ args0 -> args0 }).orElse(null),
            compressedQuery = javaType.compressedQuery().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            remediationDescription = javaType.remediationDescription().map({ args0 -> args0 }).orElse(null),
            severity = javaType.severity().map({ args0 -> args0 }).orElse(null),
            supportedCloud = javaType.supportedCloud().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
