@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * DevOps Configuration resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property properties DevOps Configuration properties.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDevOpsConfigurationResult(
    public val id: String,
    public val name: String,
    public val properties: DevOpsConfigurationPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetDevOpsConfigurationResult):
            GetDevOpsConfigurationResult = GetDevOpsConfigurationResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.security.kotlin.outputs.DevOpsConfigurationPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
