@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property id Resource ID of the virtual machine that is linked to this policy
 * @property ports The ports that were opened for the virtual machine
 */
public data class JitNetworkAccessRequestVirtualMachineResponse(
    public val id: String,
    public val ports: List<JitNetworkAccessRequestPortResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.JitNetworkAccessRequestVirtualMachineResponse):
            JitNetworkAccessRequestVirtualMachineResponse =
            JitNetworkAccessRequestVirtualMachineResponse(
                id = javaType.id(),
                ports = javaType.ports().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.security.kotlin.outputs.JitNetworkAccessRequestPortResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
