@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents a path that is recommended to be allowed and its properties
 * @property action The recommendation action of the machine or rule
 * @property common Whether the application is commonly run on the machine
 * @property configurationStatus The configuration status of the machines group or machine or rule
 * @property fileType The type of the file (for Linux files - Executable is used)
 * @property path The full path of the file, or an identifier of the application
 * @property publisherInfo Represents the publisher information of a process/rule
 * @property type The type of the rule to be allowed
 * @property userSids
 * @property usernames
 */
public data class PathRecommendationResponse(
    public val action: String? = null,
    public val common: Boolean? = null,
    public val configurationStatus: String? = null,
    public val fileType: String? = null,
    public val path: String? = null,
    public val publisherInfo: PublisherInfoResponse? = null,
    public val type: String? = null,
    public val userSids: List<String>? = null,
    public val usernames: List<UserRecommendationResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.PathRecommendationResponse):
            PathRecommendationResponse = PathRecommendationResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            common = javaType.common().map({ args0 -> args0 }).orElse(null),
            configurationStatus = javaType.configurationStatus().map({ args0 -> args0 }).orElse(null),
            fileType = javaType.fileType().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            publisherInfo = javaType.publisherInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.PublisherInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userSids = javaType.userSids().map({ args0 -> args0 }),
            usernames = javaType.usernames().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.UserRecommendationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
