@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The ETA (estimated time of arrival) for remediation
 * @property eta ETA for remediation.
 * @property justification Justification for change of Eta.
 */
public data class RemediationEtaResponse(
    public val eta: String,
    public val justification: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.RemediationEtaResponse):
            RemediationEtaResponse = RemediationEtaResponse(
            eta = javaType.eta(),
            justification = javaType.justification(),
        )
    }
}
