@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the service principal.
 * @property applicationId Application ID of service principal.
 * @property secret A secret string that the application uses to prove its identity, also can be referred to as application password (write only).
 */
public data class ServicePrincipalPropertiesResponse(
    public val applicationId: String? = null,
    public val secret: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.ServicePrincipalPropertiesResponse):
            ServicePrincipalPropertiesResponse = ServicePrincipalPropertiesResponse(
            applicationId = javaType.applicationId().map({ args0 -> args0 }).orElse(null),
            secret = javaType.secret().map({ args0 -> args0 }).orElse(null),
        )
    }
}
