@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityandcompliance.kotlin.inputs

import com.pulumi.azurenative.securityandcompliance.inputs.GetPrivateLinkServicesForM365SecurityCenterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property resourceName The name of the service instance.
 */
public data class GetPrivateLinkServicesForM365SecurityCenterPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityandcompliance.inputs.GetPrivateLinkServicesForM365SecurityCenterPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityandcompliance.inputs.GetPrivateLinkServicesForM365SecurityCenterPlainArgs =
        com.pulumi.azurenative.securityandcompliance.inputs.GetPrivateLinkServicesForM365SecurityCenterPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateLinkServicesForM365SecurityCenterPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateLinkServicesForM365SecurityCenterPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("uahnpqkuxqhrbtki")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service instance.
     */
    @JvmName("enylwkjsdsxqxvqp")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetPrivateLinkServicesForM365SecurityCenterPlainArgs =
        GetPrivateLinkServicesForM365SecurityCenterPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        )
}
