@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityandcompliance.kotlin.inputs

import com.pulumi.azurenative.securityandcompliance.inputs.ServiceCosmosDbConfigurationInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The settings for the Cosmos DB database backing the service.
 * @property keyVaultKeyUri The URI of the customer-managed key for the backing database.
 * @property offerThroughput The provisioned throughput for the backing database.
 */
public data class ServiceCosmosDbConfigurationInfoArgs(
    public val keyVaultKeyUri: Output<String>? = null,
    public val offerThroughput: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityandcompliance.inputs.ServiceCosmosDbConfigurationInfoArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityandcompliance.inputs.ServiceCosmosDbConfigurationInfoArgs =
        com.pulumi.azurenative.securityandcompliance.inputs.ServiceCosmosDbConfigurationInfoArgs.builder()
            .keyVaultKeyUri(keyVaultKeyUri?.applyValue({ args0 -> args0 }))
            .offerThroughput(offerThroughput?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceCosmosDbConfigurationInfoArgs].
 */
@PulumiTagMarker
public class ServiceCosmosDbConfigurationInfoArgsBuilder internal constructor() {
    private var keyVaultKeyUri: Output<String>? = null

    private var offerThroughput: Output<Double>? = null

    /**
     * @param value The URI of the customer-managed key for the backing database.
     */
    @JvmName("uyfgdlsbjxxoswxj")
    public suspend fun keyVaultKeyUri(`value`: Output<String>) {
        this.keyVaultKeyUri = value
    }

    /**
     * @param value The provisioned throughput for the backing database.
     */
    @JvmName("hyburjmciqftiidq")
    public suspend fun offerThroughput(`value`: Output<Double>) {
        this.offerThroughput = value
    }

    /**
     * @param value The URI of the customer-managed key for the backing database.
     */
    @JvmName("bioprstsxxjxrsmj")
    public suspend fun keyVaultKeyUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultKeyUri = mapped
    }

    /**
     * @param value The provisioned throughput for the backing database.
     */
    @JvmName("aomjofkogpsgxvwm")
    public suspend fun offerThroughput(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offerThroughput = mapped
    }

    internal fun build(): ServiceCosmosDbConfigurationInfoArgs = ServiceCosmosDbConfigurationInfoArgs(
        keyVaultKeyUri = keyVaultKeyUri,
        offerThroughput = offerThroughput,
    )
}
