@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityandcompliance.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An access policy entry.
 * @property objectId An Azure AD object ID (User or Apps) that is allowed access to the FHIR service.
 */
public data class ServiceAccessPolicyEntryResponse(
    public val objectId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityandcompliance.outputs.ServiceAccessPolicyEntryResponse):
            ServiceAccessPolicyEntryResponse = ServiceAccessPolicyEntryResponse(
            objectId = javaType.objectId(),
        )
    }
}
