@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securitydevops.kotlin.inputs

import com.pulumi.azurenative.securitydevops.inputs.AzureDevOpsProjectMetadataArgs.builder
import com.pulumi.azurenative.securitydevops.kotlin.enums.AutoDiscovery
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Project onboarding info.
 * @property autoDiscovery
 * @property name Gets or sets name of the AzureDevOps Project.
 * @property repos Gets or sets repositories.
 */
public data class AzureDevOpsProjectMetadataArgs(
    public val autoDiscovery: Output<Either<String, AutoDiscovery>>? = null,
    public val name: Output<String>? = null,
    public val repos: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securitydevops.inputs.AzureDevOpsProjectMetadataArgs> {
    override fun toJava(): com.pulumi.azurenative.securitydevops.inputs.AzureDevOpsProjectMetadataArgs =
        com.pulumi.azurenative.securitydevops.inputs.AzureDevOpsProjectMetadataArgs.builder()
            .autoDiscovery(
                autoDiscovery?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .repos(repos?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AzureDevOpsProjectMetadataArgs].
 */
@PulumiTagMarker
public class AzureDevOpsProjectMetadataArgsBuilder internal constructor() {
    private var autoDiscovery: Output<Either<String, AutoDiscovery>>? = null

    private var name: Output<String>? = null

    private var repos: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("ougfinxwqunbuxol")
    public suspend fun autoDiscovery(`value`: Output<Either<String, AutoDiscovery>>) {
        this.autoDiscovery = value
    }

    /**
     * @param value Gets or sets name of the AzureDevOps Project.
     */
    @JvmName("tbcpssvqrdrkaihr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets repositories.
     */
    @JvmName("nkpybsxiocrcuevl")
    public suspend fun repos(`value`: Output<List<String>>) {
        this.repos = value
    }

    @JvmName("xojebiasukvqwiuw")
    public suspend fun repos(vararg values: Output<String>) {
        this.repos = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets repositories.
     */
    @JvmName("oqgsjtbpndbvkhyq")
    public suspend fun repos(values: List<Output<String>>) {
        this.repos = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("rhqedunpchciifrv")
    public suspend fun autoDiscovery(`value`: Either<String, AutoDiscovery>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDiscovery = mapped
    }

    /**
     * @param value
     */
    @JvmName("yrqvdmjrofbstwpo")
    public fun autoDiscovery(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutoDiscovery>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoDiscovery = mapped
    }

    /**
     * @param value
     */
    @JvmName("atsbbekrxxjmxrgq")
    public fun autoDiscovery(`value`: AutoDiscovery) {
        val toBeMapped = Either.ofRight<String, AutoDiscovery>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoDiscovery = mapped
    }

    /**
     * @param value Gets or sets name of the AzureDevOps Project.
     */
    @JvmName("bpmjysmqasnqwakj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets repositories.
     */
    @JvmName("vuhpigvauhnbjaxq")
    public suspend fun repos(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repos = mapped
    }

    /**
     * @param values Gets or sets repositories.
     */
    @JvmName("rtabkrhvyigtfain")
    public suspend fun repos(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repos = mapped
    }

    internal fun build(): AzureDevOpsProjectMetadataArgs = AzureDevOpsProjectMetadataArgs(
        autoDiscovery = autoDiscovery,
        name = name,
        repos = repos,
    )
}
