@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securitydevops.kotlin.inputs

import com.pulumi.azurenative.securitydevops.inputs.GetGitHubConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property gitHubConnectorName Name of the GitHub Connector.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetGitHubConnectorPlainArgs(
    public val gitHubConnectorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.securitydevops.inputs.GetGitHubConnectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.securitydevops.inputs.GetGitHubConnectorPlainArgs =
        com.pulumi.azurenative.securitydevops.inputs.GetGitHubConnectorPlainArgs.builder()
            .gitHubConnectorName(gitHubConnectorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGitHubConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetGitHubConnectorPlainArgsBuilder internal constructor() {
    private var gitHubConnectorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the GitHub Connector.
     */
    @JvmName("yleqryqsecbmpgut")
    public suspend fun gitHubConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gitHubConnectorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xxauvgpnrnvushfw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGitHubConnectorPlainArgs = GetGitHubConnectorPlainArgs(
        gitHubConnectorName = gitHubConnectorName ?: throw PulumiNullFieldException("gitHubConnectorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
