@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.ASCDataConnectorArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.AlertsDataTypeOfDataConnectorArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.AlertsDataTypeOfDataConnectorArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Represents ASC (Azure Security Center) data connector.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Creates or updates an Office365 data connector.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ascDataConnector = new AzureNative.SecurityInsights.ASCDataConnector("ascDataConnector", new()
 *     {
 *         DataConnectorId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewASCDataConnector(ctx, "ascDataConnector", &securityinsights.ASCDataConnectorArgs{
 * 			DataConnectorId:   pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.ASCDataConnector;
 * import com.pulumi.azurenative.securityinsights.ASCDataConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ascDataConnector = new ASCDataConnector("ascDataConnector", ASCDataConnectorArgs.builder()
 *             .dataConnectorId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates an Threat Intelligence Platform data connector.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ascDataConnector = new AzureNative.SecurityInsights.ASCDataConnector("ascDataConnector", new()
 *     {
 *         DataConnectorId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewASCDataConnector(ctx, "ascDataConnector", &securityinsights.ASCDataConnectorArgs{
 * 			DataConnectorId:   pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.ASCDataConnector;
 * import com.pulumi.azurenative.securityinsights.ASCDataConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ascDataConnector = new ASCDataConnector("ascDataConnector", ASCDataConnectorArgs.builder()
 *             .dataConnectorId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:ASCDataConnector 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectors/{dataConnectorId}
 * ```
 * @property dataConnectorId Connector ID
 * @property dataTypes The available data types for the connector.
 * @property kind The kind of the data connector
 * Expected value is 'AzureSecurityCenter'.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property subscriptionId The subscription id to connect to, and get the data from.
 * @property workspaceName The name of the workspace.
 */
public data class ASCDataConnectorArgs(
    public val dataConnectorId: Output<String>? = null,
    public val dataTypes: Output<AlertsDataTypeOfDataConnectorArgs>? = null,
    public val kind: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.ASCDataConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.ASCDataConnectorArgs =
        com.pulumi.azurenative.securityinsights.ASCDataConnectorArgs.builder()
            .dataConnectorId(dataConnectorId?.applyValue({ args0 -> args0 }))
            .dataTypes(dataTypes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ASCDataConnectorArgs].
 */
@PulumiTagMarker
public class ASCDataConnectorArgsBuilder internal constructor() {
    private var dataConnectorId: Output<String>? = null

    private var dataTypes: Output<AlertsDataTypeOfDataConnectorArgs>? = null

    private var kind: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Connector ID
     */
    @JvmName("gybogbctprytontj")
    public suspend fun dataConnectorId(`value`: Output<String>) {
        this.dataConnectorId = value
    }

    /**
     * @param value The available data types for the connector.
     */
    @JvmName("qtjfurecquxscxpg")
    public suspend fun dataTypes(`value`: Output<AlertsDataTypeOfDataConnectorArgs>) {
        this.dataTypes = value
    }

    /**
     * @param value The kind of the data connector
     * Expected value is 'AzureSecurityCenter'.
     */
    @JvmName("wkmdfdrxfjlnjpiw")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qnpadfitprnnmovk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The subscription id to connect to, and get the data from.
     */
    @JvmName("tbgsskjcnxhtfjhc")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("qgnmjrfgwlwgsasb")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Connector ID
     */
    @JvmName("pgoojldlckuerwbb")
    public suspend fun dataConnectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataConnectorId = mapped
    }

    /**
     * @param value The available data types for the connector.
     */
    @JvmName("ohcgdsppguxldxkd")
    public suspend fun dataTypes(`value`: AlertsDataTypeOfDataConnectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataTypes = mapped
    }

    /**
     * @param argument The available data types for the connector.
     */
    @JvmName("voxakgedgfeukwev")
    public suspend
    fun dataTypes(argument: suspend AlertsDataTypeOfDataConnectorArgsBuilder.() -> Unit) {
        val toBeMapped = AlertsDataTypeOfDataConnectorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataTypes = mapped
    }

    /**
     * @param value The kind of the data connector
     * Expected value is 'AzureSecurityCenter'.
     */
    @JvmName("aggvhbkjraguclsg")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ggobhlmwhswgrgal")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The subscription id to connect to, and get the data from.
     */
    @JvmName("ekijlmeblyopveqh")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("fsjusjswiafrqoob")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ASCDataConnectorArgs = ASCDataConnectorArgs(
        dataConnectorId = dataConnectorId,
        dataTypes = dataTypes,
        kind = kind,
        resourceGroupName = resourceGroupName,
        subscriptionId = subscriptionId,
        workspaceName = workspaceName,
    )
}
