@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.AnomaliesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings with single toggle.
 * Azure REST API version: 2023-06-01-preview. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * ## Example Usage
 * ### Update EyesOn settings.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var anomalies = new AzureNative.SecurityInsights.Anomalies("anomalies", new()
 *     {
 *         ResourceGroupName = "myRg",
 *         SettingsName = "EyesOn",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewAnomalies(ctx, "anomalies", &securityinsights.AnomaliesArgs{
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			SettingsName:      pulumi.String("EyesOn"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.Anomalies;
 * import com.pulumi.azurenative.securityinsights.AnomaliesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var anomalies = new Anomalies("anomalies", AnomaliesArgs.builder()
 *             .resourceGroupName("myRg")
 *             .settingsName("EyesOn")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:Anomalies EyesOn /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/settings/{settingsName}
 * ```
 * @property kind The kind of the setting
 * Expected value is 'Anomalies'.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property settingsName The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba
 * @property workspaceName The name of the workspace.
 */
public data class AnomaliesArgs(
    public val kind: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val settingsName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.AnomaliesArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.AnomaliesArgs =
        com.pulumi.azurenative.securityinsights.AnomaliesArgs.builder()
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .settingsName(settingsName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnomaliesArgs].
 */
@PulumiTagMarker
public class AnomaliesArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var settingsName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The kind of the setting
     * Expected value is 'Anomalies'.
     */
    @JvmName("ephrojvhsdxyfjlg")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hfnhnukpayqsokle")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba
     */
    @JvmName("nhevisumgsqudyvd")
    public suspend fun settingsName(`value`: Output<String>) {
        this.settingsName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("bsrnwnkdaolbhbkl")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The kind of the setting
     * Expected value is 'Anomalies'.
     */
    @JvmName("vomlhdkbawqhxecd")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dfehqpmauwhqtrvo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba
     */
    @JvmName("lhsddwppguscgbsh")
    public suspend fun settingsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settingsName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("trvasysgergclnsy")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): AnomaliesArgs = AnomaliesArgs(
        kind = kind,
        resourceGroupName = resourceGroupName,
        settingsName = settingsName,
        workspaceName = workspaceName,
    )
}
