@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.AnomalySecurityMLAnalyticsSettingsArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.AttackTactic
import com.pulumi.azurenative.securityinsights.kotlin.enums.SettingsStatus
import com.pulumi.azurenative.securityinsights.kotlin.inputs.SecurityMLAnalyticsSettingsDataSourceArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.SecurityMLAnalyticsSettingsDataSourceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents Anomaly Security ML Analytics Settings
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-05-01-preview.
 * ## Example Usage
 * ### Creates or updates a Anomaly Security ML Analytics Settings.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var anomalySecurityMLAnalyticsSettings = new AzureNative.SecurityInsights.AnomalySecurityMLAnalyticsSettings("anomalySecurityMLAnalyticsSettings", new()
 *     {
 *         AnomalySettingsVersion = 0,
 *         AnomalyVersion = "1.0.5",
 *         CustomizableObservations =
 *         {
 *             { "multiSelectObservations", null },
 *             { "prioritizeExcludeObservations", null },
 *             { "singleSelectObservations", new[]
 *             {
 *                 {
 *                     { "description", "Select device vendor of network connection logs from CommonSecurityLog" },
 *                     { "name", "Device vendor" },
 *                     { "rerun", "RerunAlways" },
 *                     { "sequenceNumber", 1 },
 *                     { "supportedValues", new[]
 *                     {
 *                         "Palo Alto Networks",
 *                         "Fortinet",
 *                         "Check Point",
 *                     } },
 *                     { "supportedValuesKql", null },
 *                     { "value", new[]
 *                     {
 *                         "Palo Alto Networks",
 *                     } },
 *                     { "valuesKql", null },
 *                 },
 *             } },
 *             { "singleValueObservations", null },
 *             { "thresholdObservations", new[]
 *             {
 *                 {
 *                     { "description", "Suppress anomalies when daily data transfered (in MB) per hour is less than the chosen value" },
 *                     { "maximum", "100" },
 *                     { "minimum", "1" },
 *                     { "name", "Daily data transfer threshold in MB" },
 *                     { "rerun", "RerunAlways" },
 *                     { "sequenceNumber", 1 },
 *                     { "value", "25" },
 *                 },
 *                 {
 *                     { "description", "Triggers anomalies when number of standard deviations is greater than the chosen value" },
 *                     { "maximum", "10" },
 *                     { "minimum", "2" },
 *                     { "name", "Number of standard deviations" },
 *                     { "rerun", "RerunAlways" },
 *                     { "sequenceNumber", 2 },
 *                     { "value", "3" },
 *                 },
 *             } },
 *         },
 *         Description = "When account logs from a source region that has rarely been logged in from during the last 14 days, an anomaly is triggered.",
 *         DisplayName = "Login from unusual region",
 *         Enabled = true,
 *         Frequency = "PT1H",
 *         IsDefaultSettings = true,
 *         Kind = "Anomaly",
 *         RequiredDataConnectors = new[]
 *         {
 *             new AzureNative.SecurityInsights.Inputs.SecurityMLAnalyticsSettingsDataSourceArgs
 *             {
 *                 ConnectorId = "AWS",
 *                 DataTypes = new[]
 *                 {
 *                     "AWSCloudTrail",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myRg",
 *         SettingsDefinitionId = "f209187f-1d17-4431-94af-c141bf5f23db",
 *         SettingsResourceName = "f209187f-1d17-4431-94af-c141bf5f23db",
 *         SettingsStatus = "Production",
 *         Tactics = new[]
 *         {
 *             "Exfiltration",
 *             "CommandAndControl",
 *         },
 *         Techniques = new[]
 *         {
 *             "T1037",
 *             "T1021",
 *         },
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewAnomalySecurityMLAnalyticsSettings(ctx, "anomalySecurityMLAnalyticsSettings", &securityinsights.AnomalySecurityMLAnalyticsSettingsArgs{
 * 			AnomalySettingsVersion: pulumi.Int(0),
 * 			AnomalyVersion:         pulumi.String("1.0.5"),
 * 			CustomizableObservations: pulumi.Any{
 * 				MultiSelectObservations:       nil,
 * 				PrioritizeExcludeObservations: nil,
 * 				SingleSelectObservations: []map[string]interface{}{
 * 					map[string]interface{}{
 * 						"description":    "Select device vendor of network connection logs from CommonSecurityLog",
 * 						"name":           "Device vendor",
 * 						"rerun":          "RerunAlways",
 * 						"sequenceNumber": 1,
 * 						"supportedValues": []string{
 * 							"Palo Alto Networks",
 * 							"Fortinet",
 * 							"Check Point",
 * 						},
 * 						"supportedValuesKql": nil,
 * 						"value": []string{
 * 							"Palo Alto Networks",
 * 						},
 * 						"valuesKql": nil,
 * 					},
 * 				},
 * 				SingleValueObservations: nil,
 * 				ThresholdObservations: []interface{}{
 * 					map[string]interface{}{
 * 						"description":    "Suppress anomalies when daily data transfered (in MB) per hour is less than the chosen value",
 * 						"maximum":        "100",
 * 						"minimum":        "1",
 * 						"name":           "Daily data transfer threshold in MB",
 * 						"rerun":          "RerunAlways",
 * 						"sequenceNumber": 1,
 * 						"value":          "25",
 * 					},
 * 					map[string]interface{}{
 * 						"description":    "Triggers anomalies when number of standard deviations is greater than the chosen value",
 * 						"maximum":        "10",
 * 						"minimum":        "2",
 * 						"name":           "Number of standard deviations",
 * 						"rerun":          "RerunAlways",
 * 						"sequenceNumber": 2,
 * 						"value":          "3",
 * 					},
 * 				},
 * 			},
 * 			Description:       pulumi.String("When account logs from a source region that has rarely been logged in from during the last 14 days, an anomaly is triggered."),
 * 			DisplayName:       pulumi.String("Login from unusual region"),
 * 			Enabled:           pulumi.Bool(true),
 * 			Frequency:         pulumi.String("PT1H"),
 * 			IsDefaultSettings: pulumi.Bool(true),
 * 			Kind:              pulumi.String("Anomaly"),
 * 			RequiredDataConnectors: []securityinsights.SecurityMLAnalyticsSettingsDataSourceArgs{
 * 				{
 * 					ConnectorId: pulumi.String("AWS"),
 * 					DataTypes: pulumi.StringArray{
 * 						pulumi.String("AWSCloudTrail"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName:    pulumi.String("myRg"),
 * 			SettingsDefinitionId: pulumi.String("f209187f-1d17-4431-94af-c141bf5f23db"),
 * 			SettingsResourceName: pulumi.String("f209187f-1d17-4431-94af-c141bf5f23db"),
 * 			SettingsStatus:       pulumi.String("Production"),
 * 			Tactics: pulumi.StringArray{
 * 				pulumi.String("Exfiltration"),
 * 				pulumi.String("CommandAndControl"),
 * 			},
 * 			Techniques: pulumi.StringArray{
 * 				pulumi.String("T1037"),
 * 				pulumi.String("T1021"),
 * 			},
 * 			WorkspaceName: pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.AnomalySecurityMLAnalyticsSettings;
 * import com.pulumi.azurenative.securityinsights.AnomalySecurityMLAnalyticsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var anomalySecurityMLAnalyticsSettings = new AnomalySecurityMLAnalyticsSettings("anomalySecurityMLAnalyticsSettings", AnomalySecurityMLAnalyticsSettingsArgs.builder()
 *             .anomalySettingsVersion(0)
 *             .anomalyVersion("1.0.5")
 *             .customizableObservations(Map.ofEntries(
 *                 Map.entry("multiSelectObservations", null),
 *                 Map.entry("prioritizeExcludeObservations", null),
 *                 Map.entry("singleSelectObservations", Map.ofEntries(
 *                     Map.entry("description", "Select device vendor of network connection logs from CommonSecurityLog"),
 *                     Map.entry("name", "Device vendor"),
 *                     Map.entry("rerun", "RerunAlways"),
 *                     Map.entry("sequenceNumber", 1),
 *                     Map.entry("supportedValues",
 *                         "Palo Alto Networks",
 *                         "Fortinet",
 *                         "Check Point"),
 *                     Map.entry("supportedValuesKql", null),
 *                     Map.entry("value", "Palo Alto Networks"),
 *                     Map.entry("valuesKql", null)
 *                 )),
 *                 Map.entry("singleValueObservations", null),
 *                 Map.entry("thresholdObservations",
 *                     Map.ofEntries(
 *                         Map.entry("description", "Suppress anomalies when daily data transfered (in MB) per hour is less than the chosen value"),
 *                         Map.entry("maximum", "100"),
 *                         Map.entry("minimum", "1"),
 *                         Map.entry("name", "Daily data transfer threshold in MB"),
 *                         Map.entry("rerun", "RerunAlways"),
 *                         Map.entry("sequenceNumber", 1),
 *                         Map.entry("value", "25")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "Triggers anomalies when number of standard deviations is greater than the chosen value"),
 *                         Map.entry("maximum", "10"),
 *                         Map.entry("minimum", "2"),
 *                         Map.entry("name", "Number of standard deviations"),
 *                         Map.entry("rerun", "RerunAlways"),
 *                         Map.entry("sequenceNumber", 2),
 *                         Map.entry("value", "3")
 *                     ))
 *             ))
 *             .description("When account logs from a source region that has rarely been logged in from during the last 14 days, an anomaly is triggered.")
 *             .displayName("Login from unusual region")
 *             .enabled(true)
 *             .frequency("PT1H")
 *             .isDefaultSettings(true)
 *             .kind("Anomaly")
 *             .requiredDataConnectors(Map.ofEntries(
 *                 Map.entry("connectorId", "AWS"),
 *                 Map.entry("dataTypes", "AWSCloudTrail")
 *             ))
 *             .resourceGroupName("myRg")
 *             .settingsDefinitionId("f209187f-1d17-4431-94af-c141bf5f23db")
 *             .settingsResourceName("f209187f-1d17-4431-94af-c141bf5f23db")
 *             .settingsStatus("Production")
 *             .tactics(
 *                 "Exfiltration",
 *                 "CommandAndControl")
 *             .techniques(
 *                 "T1037",
 *                 "T1021")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:AnomalySecurityMLAnalyticsSettings f209187f-1d17-4431-94af-c141bf5f23db /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/securityMLAnalyticsSettings/{settingsResourceName}
 * ```
 * @property anomalySettingsVersion The anomaly settings version of the Anomaly security ml analytics settings that dictates whether job version gets updated or not.
 * @property anomalyVersion The anomaly version of the AnomalySecurityMLAnalyticsSettings.
 * @property customizableObservations The customizable observations of the AnomalySecurityMLAnalyticsSettings.
 * @property description The description of the SecurityMLAnalyticsSettings.
 * @property displayName The display name for settings created by this SecurityMLAnalyticsSettings.
 * @property enabled Determines whether this settings is enabled or disabled.
 * @property frequency The frequency that this SecurityMLAnalyticsSettings will be run.
 * @property isDefaultSettings Determines whether this anomaly security ml analytics settings is a default settings
 * @property kind The kind of security ML analytics settings
 * Expected value is 'Anomaly'.
 * @property requiredDataConnectors The required data sources for this SecurityMLAnalyticsSettings
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property settingsDefinitionId The anomaly settings definition Id
 * @property settingsResourceName Security ML Analytics Settings resource name
 * @property settingsStatus The anomaly SecurityMLAnalyticsSettings status
 * @property tactics The tactics of the SecurityMLAnalyticsSettings
 * @property techniques The techniques of the SecurityMLAnalyticsSettings
 * @property workspaceName The name of the workspace.
 */
public data class AnomalySecurityMLAnalyticsSettingsArgs(
    public val anomalySettingsVersion: Output<Int>? = null,
    public val anomalyVersion: Output<String>? = null,
    public val customizableObservations: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val frequency: Output<String>? = null,
    public val isDefaultSettings: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val requiredDataConnectors: Output<List<SecurityMLAnalyticsSettingsDataSourceArgs>>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val settingsDefinitionId: Output<String>? = null,
    public val settingsResourceName: Output<String>? = null,
    public val settingsStatus: Output<Either<String, SettingsStatus>>? = null,
    public val tactics: Output<List<Either<String, AttackTactic>>>? = null,
    public val techniques: Output<List<String>>? = null,
    public val workspaceName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.AnomalySecurityMLAnalyticsSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.AnomalySecurityMLAnalyticsSettingsArgs =
        com.pulumi.azurenative.securityinsights.AnomalySecurityMLAnalyticsSettingsArgs.builder()
            .anomalySettingsVersion(anomalySettingsVersion?.applyValue({ args0 -> args0 }))
            .anomalyVersion(anomalyVersion?.applyValue({ args0 -> args0 }))
            .customizableObservations(customizableObservations?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .frequency(frequency?.applyValue({ args0 -> args0 }))
            .isDefaultSettings(isDefaultSettings?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .requiredDataConnectors(
                requiredDataConnectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .settingsDefinitionId(settingsDefinitionId?.applyValue({ args0 -> args0 }))
            .settingsResourceName(settingsResourceName?.applyValue({ args0 -> args0 }))
            .settingsStatus(
                settingsStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tactics(
                tactics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .techniques(techniques?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnomalySecurityMLAnalyticsSettingsArgs].
 */
@PulumiTagMarker
public class AnomalySecurityMLAnalyticsSettingsArgsBuilder internal constructor() {
    private var anomalySettingsVersion: Output<Int>? = null

    private var anomalyVersion: Output<String>? = null

    private var customizableObservations: Output<Any>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var frequency: Output<String>? = null

    private var isDefaultSettings: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var requiredDataConnectors: Output<List<SecurityMLAnalyticsSettingsDataSourceArgs>>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var settingsDefinitionId: Output<String>? = null

    private var settingsResourceName: Output<String>? = null

    private var settingsStatus: Output<Either<String, SettingsStatus>>? = null

    private var tactics: Output<List<Either<String, AttackTactic>>>? = null

    private var techniques: Output<List<String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The anomaly settings version of the Anomaly security ml analytics settings that dictates whether job version gets updated or not.
     */
    @JvmName("lcmjlchqqrgiwxrl")
    public suspend fun anomalySettingsVersion(`value`: Output<Int>) {
        this.anomalySettingsVersion = value
    }

    /**
     * @param value The anomaly version of the AnomalySecurityMLAnalyticsSettings.
     */
    @JvmName("boxoyfindorwlivh")
    public suspend fun anomalyVersion(`value`: Output<String>) {
        this.anomalyVersion = value
    }

    /**
     * @param value The customizable observations of the AnomalySecurityMLAnalyticsSettings.
     */
    @JvmName("xpcpujepkixahqej")
    public suspend fun customizableObservations(`value`: Output<Any>) {
        this.customizableObservations = value
    }

    /**
     * @param value The description of the SecurityMLAnalyticsSettings.
     */
    @JvmName("ibplpysbpselltcn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name for settings created by this SecurityMLAnalyticsSettings.
     */
    @JvmName("bxakgogxxyxkrnbt")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Determines whether this settings is enabled or disabled.
     */
    @JvmName("kbpshcdwwoyxglrw")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The frequency that this SecurityMLAnalyticsSettings will be run.
     */
    @JvmName("qwutnwghedvhjvbo")
    public suspend fun frequency(`value`: Output<String>) {
        this.frequency = value
    }

    /**
     * @param value Determines whether this anomaly security ml analytics settings is a default settings
     */
    @JvmName("pgclhlkoypfwucan")
    public suspend fun isDefaultSettings(`value`: Output<Boolean>) {
        this.isDefaultSettings = value
    }

    /**
     * @param value The kind of security ML analytics settings
     * Expected value is 'Anomaly'.
     */
    @JvmName("wpoqtsufwyvehcik")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The required data sources for this SecurityMLAnalyticsSettings
     */
    @JvmName("ijmojexxfshegtae")
    public suspend
    fun requiredDataConnectors(`value`: Output<List<SecurityMLAnalyticsSettingsDataSourceArgs>>) {
        this.requiredDataConnectors = value
    }

    @JvmName("vttjdtynujcophls")
    public suspend fun requiredDataConnectors(
        vararg
        values: Output<SecurityMLAnalyticsSettingsDataSourceArgs>,
    ) {
        this.requiredDataConnectors = Output.all(values.asList())
    }

    /**
     * @param values The required data sources for this SecurityMLAnalyticsSettings
     */
    @JvmName("pmrbpiupcboujknr")
    public suspend
    fun requiredDataConnectors(values: List<Output<SecurityMLAnalyticsSettingsDataSourceArgs>>) {
        this.requiredDataConnectors = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nprwyvmobtbuikrf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The anomaly settings definition Id
     */
    @JvmName("dxxmjsbvkqvsxuty")
    public suspend fun settingsDefinitionId(`value`: Output<String>) {
        this.settingsDefinitionId = value
    }

    /**
     * @param value Security ML Analytics Settings resource name
     */
    @JvmName("dnjoaeauoyghdqjx")
    public suspend fun settingsResourceName(`value`: Output<String>) {
        this.settingsResourceName = value
    }

    /**
     * @param value The anomaly SecurityMLAnalyticsSettings status
     */
    @JvmName("bjaqjhtmurbtievc")
    public suspend fun settingsStatus(`value`: Output<Either<String, SettingsStatus>>) {
        this.settingsStatus = value
    }

    /**
     * @param value The tactics of the SecurityMLAnalyticsSettings
     */
    @JvmName("jmeyqdlvrgcmtoki")
    public suspend fun tactics(`value`: Output<List<Either<String, AttackTactic>>>) {
        this.tactics = value
    }

    @JvmName("gvkeccbowxydxioe")
    public suspend fun tactics(vararg values: Output<Either<String, AttackTactic>>) {
        this.tactics = Output.all(values.asList())
    }

    /**
     * @param values The tactics of the SecurityMLAnalyticsSettings
     */
    @JvmName("bsqdrerjfjdjsjdt")
    public suspend fun tactics(values: List<Output<Either<String, AttackTactic>>>) {
        this.tactics = Output.all(values)
    }

    /**
     * @param value The techniques of the SecurityMLAnalyticsSettings
     */
    @JvmName("rpobfeuxtyfpfimo")
    public suspend fun techniques(`value`: Output<List<String>>) {
        this.techniques = value
    }

    @JvmName("tnvpycvycryeqrdh")
    public suspend fun techniques(vararg values: Output<String>) {
        this.techniques = Output.all(values.asList())
    }

    /**
     * @param values The techniques of the SecurityMLAnalyticsSettings
     */
    @JvmName("yubufgkslgpivlai")
    public suspend fun techniques(values: List<Output<String>>) {
        this.techniques = Output.all(values)
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("fveiftxbgnolixqh")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The anomaly settings version of the Anomaly security ml analytics settings that dictates whether job version gets updated or not.
     */
    @JvmName("ypkiuxurjkiglagn")
    public suspend fun anomalySettingsVersion(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.anomalySettingsVersion = mapped
    }

    /**
     * @param value The anomaly version of the AnomalySecurityMLAnalyticsSettings.
     */
    @JvmName("maehiwraobbcgloo")
    public suspend fun anomalyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.anomalyVersion = mapped
    }

    /**
     * @param value The customizable observations of the AnomalySecurityMLAnalyticsSettings.
     */
    @JvmName("fgijintifooxryev")
    public suspend fun customizableObservations(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customizableObservations = mapped
    }

    /**
     * @param value The description of the SecurityMLAnalyticsSettings.
     */
    @JvmName("hrjnxgwppvotdsye")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name for settings created by this SecurityMLAnalyticsSettings.
     */
    @JvmName("noicvrhciqnaoinw")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Determines whether this settings is enabled or disabled.
     */
    @JvmName("masnicrpyfgnteop")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The frequency that this SecurityMLAnalyticsSettings will be run.
     */
    @JvmName("cmhbeqkmxgtdokqm")
    public suspend fun frequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Determines whether this anomaly security ml analytics settings is a default settings
     */
    @JvmName("fbcdinevbmdoeioi")
    public suspend fun isDefaultSettings(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDefaultSettings = mapped
    }

    /**
     * @param value The kind of security ML analytics settings
     * Expected value is 'Anomaly'.
     */
    @JvmName("umrbmhvgmxrtkhdm")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The required data sources for this SecurityMLAnalyticsSettings
     */
    @JvmName("nxplvwtwgnpojlxk")
    public suspend
    fun requiredDataConnectors(`value`: List<SecurityMLAnalyticsSettingsDataSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredDataConnectors = mapped
    }

    /**
     * @param argument The required data sources for this SecurityMLAnalyticsSettings
     */
    @JvmName("xqcrrxectvgpbbko")
    public suspend
    fun requiredDataConnectors(argument: List<suspend SecurityMLAnalyticsSettingsDataSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SecurityMLAnalyticsSettingsDataSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.requiredDataConnectors = mapped
    }

    /**
     * @param argument The required data sources for this SecurityMLAnalyticsSettings
     */
    @JvmName("oyybhuoebyipebuc")
    public suspend fun requiredDataConnectors(
        vararg
        argument: suspend SecurityMLAnalyticsSettingsDataSourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SecurityMLAnalyticsSettingsDataSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.requiredDataConnectors = mapped
    }

    /**
     * @param argument The required data sources for this SecurityMLAnalyticsSettings
     */
    @JvmName("cnlfwwxrweofxpan")
    public suspend
    fun requiredDataConnectors(argument: suspend SecurityMLAnalyticsSettingsDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SecurityMLAnalyticsSettingsDataSourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.requiredDataConnectors = mapped
    }

    /**
     * @param values The required data sources for this SecurityMLAnalyticsSettings
     */
    @JvmName("syyetuitjudxaiiw")
    public suspend fun requiredDataConnectors(
        vararg
        values: SecurityMLAnalyticsSettingsDataSourceArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredDataConnectors = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ystacalahajaebih")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The anomaly settings definition Id
     */
    @JvmName("fxnguqtrcsaybfbh")
    public suspend fun settingsDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settingsDefinitionId = mapped
    }

    /**
     * @param value Security ML Analytics Settings resource name
     */
    @JvmName("brqtbsdtmlpocjxe")
    public suspend fun settingsResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settingsResourceName = mapped
    }

    /**
     * @param value The anomaly SecurityMLAnalyticsSettings status
     */
    @JvmName("xsfpoxhqijwltarj")
    public suspend fun settingsStatus(`value`: Either<String, SettingsStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settingsStatus = mapped
    }

    /**
     * @param value The anomaly SecurityMLAnalyticsSettings status
     */
    @JvmName("ojilisadxjmjnguv")
    public fun settingsStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SettingsStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.settingsStatus = mapped
    }

    /**
     * @param value The anomaly SecurityMLAnalyticsSettings status
     */
    @JvmName("idyfbnwbpcnglemi")
    public fun settingsStatus(`value`: SettingsStatus) {
        val toBeMapped = Either.ofRight<String, SettingsStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.settingsStatus = mapped
    }

    /**
     * @param value The tactics of the SecurityMLAnalyticsSettings
     */
    @JvmName("cqlihxmbgklsmhae")
    public suspend fun tactics(`value`: List<Either<String, AttackTactic>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tactics = mapped
    }

    /**
     * @param values The tactics of the SecurityMLAnalyticsSettings
     */
    @JvmName("cgqffsdujoipotlv")
    public suspend fun tactics(vararg values: Either<String, AttackTactic>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tactics = mapped
    }

    /**
     * @param value The techniques of the SecurityMLAnalyticsSettings
     */
    @JvmName("hlqybkxrcavfppci")
    public suspend fun techniques(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.techniques = mapped
    }

    /**
     * @param values The techniques of the SecurityMLAnalyticsSettings
     */
    @JvmName("abnvfmsdjvhvugkm")
    public suspend fun techniques(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.techniques = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("oduqkjvvhbqcrpnl")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): AnomalySecurityMLAnalyticsSettingsArgs =
        AnomalySecurityMLAnalyticsSettingsArgs(
            anomalySettingsVersion = anomalySettingsVersion,
            anomalyVersion = anomalyVersion,
            customizableObservations = customizableObservations,
            description = description,
            displayName = displayName,
            enabled = enabled,
            frequency = frequency,
            isDefaultSettings = isDefaultSettings,
            kind = kind,
            requiredDataConnectors = requiredDataConnectors,
            resourceGroupName = resourceGroupName,
            settingsDefinitionId = settingsDefinitionId,
            settingsResourceName = settingsResourceName,
            settingsStatus = settingsStatus,
            tactics = tactics,
            techniques = techniques,
            workspaceName = workspaceName,
        )
}
