@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentInfoResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.UserInfoResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentInfoResponse.Companion.toKotlin as incidentInfoResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.UserInfoResponse.Companion.toKotlin as userInfoResponseToKotlin

/**
 * Builder for [Bookmark].
 */
@PulumiTagMarker
public class BookmarkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BookmarkArgs = BookmarkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BookmarkArgsBuilder.() -> Unit) {
        val builder = BookmarkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Bookmark {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.Bookmark(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Bookmark(builtJavaResource)
    }
}

/**
 * Represents a bookmark in Azure Security Insights.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * Other available API versions: 2019-01-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### Creates or updates a bookmark.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bookmark = new AzureNative.SecurityInsights.Bookmark("bookmark", new()
 *     {
 *         BookmarkId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         Created = "2019-01-01T13:15:30Z",
 *         CreatedBy = new AzureNative.SecurityInsights.Inputs.UserInfoArgs
 *         {
 *             ObjectId = "2046feea-040d-4a46-9e2b-91c2941bfa70",
 *         },
 *         DisplayName = "My bookmark",
 *         Labels = new[]
 *         {
 *             "Tag1",
 *             "Tag2",
 *         },
 *         Notes = "Found a suspicious activity",
 *         Query = "SecurityEvent | where TimeGenerated > ago(1d) and TimeGenerated < ago(2d)",
 *         QueryResult = "Security Event query result",
 *         ResourceGroupName = "myRg",
 *         Updated = "2019-01-01T13:15:30Z",
 *         UpdatedBy = new AzureNative.SecurityInsights.Inputs.UserInfoArgs
 *         {
 *             ObjectId = "2046feea-040d-4a46-9e2b-91c2941bfa70",
 *         },
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewBookmark(ctx, "bookmark", &securityinsights.BookmarkArgs{
 * 			BookmarkId: pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			Created:    pulumi.String("2019-01-01T13:15:30Z"),
 * 			CreatedBy: &securityinsights.UserInfoArgs{
 * 				ObjectId: pulumi.String("2046feea-040d-4a46-9e2b-91c2941bfa70"),
 * 			},
 * 			DisplayName: pulumi.String("My bookmark"),
 * 			Labels: pulumi.StringArray{
 * 				pulumi.String("Tag1"),
 * 				pulumi.String("Tag2"),
 * 			},
 * 			Notes:             pulumi.String("Found a suspicious activity"),
 * 			Query:             pulumi.String("SecurityEvent | where TimeGenerated > ago(1d) and TimeGenerated < ago(2d)"),
 * 			QueryResult:       pulumi.String("Security Event query result"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Updated:           pulumi.String("2019-01-01T13:15:30Z"),
 * 			UpdatedBy: &securityinsights.UserInfoArgs{
 * 				ObjectId: pulumi.String("2046feea-040d-4a46-9e2b-91c2941bfa70"),
 * 			},
 * 			WorkspaceName: pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.Bookmark;
 * import com.pulumi.azurenative.securityinsights.BookmarkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bookmark = new Bookmark("bookmark", BookmarkArgs.builder()
 *             .bookmarkId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .created("2019-01-01T13:15:30Z")
 *             .createdBy(Map.of("objectId", "2046feea-040d-4a46-9e2b-91c2941bfa70"))
 *             .displayName("My bookmark")
 *             .labels(
 *                 "Tag1",
 *                 "Tag2")
 *             .notes("Found a suspicious activity")
 *             .query("SecurityEvent | where TimeGenerated > ago(1d) and TimeGenerated < ago(2d)")
 *             .queryResult("Security Event query result")
 *             .resourceGroupName("myRg")
 *             .updated("2019-01-01T13:15:30Z")
 *             .updatedBy(Map.of("objectId", "2046feea-040d-4a46-9e2b-91c2941bfa70"))
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:Bookmark 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/bookmarks/{bookmarkId}
 * ```
 */
public class Bookmark internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.Bookmark,
) : KotlinCustomResource(javaResource, BookmarkMapper) {
    /**
     * The time the bookmark was created
     */
    public val created: Output<String>?
        get() = javaResource.created().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Describes a user that created the bookmark
     */
    public val createdBy: Output<UserInfoResponse>?
        get() = javaResource.createdBy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    userInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The display name of the bookmark
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The bookmark event time
     */
    public val eventTime: Output<String>?
        get() = javaResource.eventTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Describes an incident that relates to bookmark
     */
    public val incidentInfo: Output<IncidentInfoResponse>?
        get() = javaResource.incidentInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    incidentInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of labels relevant to this bookmark
     */
    public val labels: Output<List<String>>?
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The notes of the bookmark
     */
    public val notes: Output<String>?
        get() = javaResource.notes().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The query of the bookmark.
     */
    public val query: Output<String>
        get() = javaResource.query().applyValue({ args0 -> args0 })

    /**
     * The end time for the query
     */
    public val queryEndTime: Output<String>?
        get() = javaResource.queryEndTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The query result of the bookmark.
     */
    public val queryResult: Output<String>?
        get() = javaResource.queryResult().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The start time for the query
     */
    public val queryStartTime: Output<String>?
        get() = javaResource.queryStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The last time the bookmark was updated
     */
    public val updated: Output<String>?
        get() = javaResource.updated().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Describes a user that updated the bookmark
     */
    public val updatedBy: Output<UserInfoResponse>?
        get() = javaResource.updatedBy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    userInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object BookmarkMapper : ResourceMapper<Bookmark> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.Bookmark::class == javaResource::class

    override fun map(javaResource: Resource): Bookmark = Bookmark(
        javaResource as
            com.pulumi.azurenative.securityinsights.Bookmark,
    )
}

/**
 * @see [Bookmark].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Bookmark].
 */
public suspend fun bookmark(name: String, block: suspend BookmarkResourceBuilder.() -> Unit):
    Bookmark {
    val builder = BookmarkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Bookmark].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bookmark(name: String): Bookmark {
    val builder = BookmarkResourceBuilder()
    builder.name(name)
    return builder.build()
}
