@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.ContentPackageArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.Flag
import com.pulumi.azurenative.securityinsights.kotlin.enums.PackageKind
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataAuthorArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataAuthorArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataCategoriesArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataCategoriesArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataDependenciesArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataDependenciesArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataSourceArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataSourceArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataSupportArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataSupportArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents a Package in Azure Security Insights.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### Install a package to the workspace.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contentPackage = new AzureNative.SecurityInsights.ContentPackage("contentPackage", new()
 *     {
 *         ContentId = "str.azure-sentinel-solution-str",
 *         ContentKind = "Solution",
 *         DisplayName = "str",
 *         PackageId = "str.azure-sentinel-solution-str",
 *         ResourceGroupName = "myRg",
 *         Version = "2.0.0",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewContentPackage(ctx, "contentPackage", &securityinsights.ContentPackageArgs{
 * 			ContentId:         pulumi.String("str.azure-sentinel-solution-str"),
 * 			ContentKind:       pulumi.String("Solution"),
 * 			DisplayName:       pulumi.String("str"),
 * 			PackageId:         pulumi.String("str.azure-sentinel-solution-str"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Version:           pulumi.String("2.0.0"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.ContentPackage;
 * import com.pulumi.azurenative.securityinsights.ContentPackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contentPackage = new ContentPackage("contentPackage", ContentPackageArgs.builder()
 *             .contentId("str.azure-sentinel-solution-str")
 *             .contentKind("Solution")
 *             .displayName("str")
 *             .packageId("str.azure-sentinel-solution-str")
 *             .resourceGroupName("myRg")
 *             .version("2.0.0")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:ContentPackage str.azure-sentinel-solution-str /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentPackages/{packageId}
 * ```
 * @property author The author of the package
 * @property categories The categories of the package
 * @property contentId The package id
 * @property contentKind The package kind
 * @property contentSchemaVersion The version of the content schema.
 * @property dependencies The support tier of the package
 * @property description The description of the package
 * @property displayName The display name of the package
 * @property firstPublishDate first publish date package item
 * @property icon the icon identifier. this id can later be fetched from the content metadata
 * @property isFeatured Flag indicates if this package is among the featured list.
 * @property isNew Flag indicates if this is a newly published package.
 * @property isPreview Flag indicates if this package is in preview.
 * @property lastPublishDate last publish date for the package item
 * @property packageId package Id
 * @property providers Providers for the package item
 * @property publisherDisplayName The publisher display name of the package
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property source The source of the package
 * @property support The support tier of the package
 * @property threatAnalysisTactics the tactics the resource covers
 * @property threatAnalysisTechniques the techniques the resource covers, these have to be aligned with the tactics being used
 * @property version the latest version number of the package
 * @property workspaceName The name of the workspace.
 */
public data class ContentPackageArgs(
    public val author: Output<MetadataAuthorArgs>? = null,
    public val categories: Output<MetadataCategoriesArgs>? = null,
    public val contentId: Output<String>? = null,
    public val contentKind: Output<Either<String, PackageKind>>? = null,
    public val contentSchemaVersion: Output<String>? = null,
    public val dependencies: Output<MetadataDependenciesArgs>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val firstPublishDate: Output<String>? = null,
    public val icon: Output<String>? = null,
    public val isFeatured: Output<Either<String, Flag>>? = null,
    public val isNew: Output<Either<String, Flag>>? = null,
    public val isPreview: Output<Either<String, Flag>>? = null,
    public val lastPublishDate: Output<String>? = null,
    public val packageId: Output<String>? = null,
    public val providers: Output<List<String>>? = null,
    public val publisherDisplayName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val source: Output<MetadataSourceArgs>? = null,
    public val support: Output<MetadataSupportArgs>? = null,
    public val threatAnalysisTactics: Output<List<String>>? = null,
    public val threatAnalysisTechniques: Output<List<String>>? = null,
    public val version: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.ContentPackageArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.ContentPackageArgs =
        com.pulumi.azurenative.securityinsights.ContentPackageArgs.builder()
            .author(author?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .categories(categories?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .contentId(contentId?.applyValue({ args0 -> args0 }))
            .contentKind(
                contentKind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .contentSchemaVersion(contentSchemaVersion?.applyValue({ args0 -> args0 }))
            .dependencies(dependencies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .firstPublishDate(firstPublishDate?.applyValue({ args0 -> args0 }))
            .icon(icon?.applyValue({ args0 -> args0 }))
            .isFeatured(
                isFeatured?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .isNew(
                isNew?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .isPreview(
                isPreview?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .lastPublishDate(lastPublishDate?.applyValue({ args0 -> args0 }))
            .packageId(packageId?.applyValue({ args0 -> args0 }))
            .providers(providers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .publisherDisplayName(publisherDisplayName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .support(support?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .threatAnalysisTactics(threatAnalysisTactics?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .threatAnalysisTechniques(
                threatAnalysisTechniques?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .version(version?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentPackageArgs].
 */
@PulumiTagMarker
public class ContentPackageArgsBuilder internal constructor() {
    private var author: Output<MetadataAuthorArgs>? = null

    private var categories: Output<MetadataCategoriesArgs>? = null

    private var contentId: Output<String>? = null

    private var contentKind: Output<Either<String, PackageKind>>? = null

    private var contentSchemaVersion: Output<String>? = null

    private var dependencies: Output<MetadataDependenciesArgs>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var firstPublishDate: Output<String>? = null

    private var icon: Output<String>? = null

    private var isFeatured: Output<Either<String, Flag>>? = null

    private var isNew: Output<Either<String, Flag>>? = null

    private var isPreview: Output<Either<String, Flag>>? = null

    private var lastPublishDate: Output<String>? = null

    private var packageId: Output<String>? = null

    private var providers: Output<List<String>>? = null

    private var publisherDisplayName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var source: Output<MetadataSourceArgs>? = null

    private var support: Output<MetadataSupportArgs>? = null

    private var threatAnalysisTactics: Output<List<String>>? = null

    private var threatAnalysisTechniques: Output<List<String>>? = null

    private var version: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The author of the package
     */
    @JvmName("xrymcnebljgabdcj")
    public suspend fun author(`value`: Output<MetadataAuthorArgs>) {
        this.author = value
    }

    /**
     * @param value The categories of the package
     */
    @JvmName("domwmxaejeasogma")
    public suspend fun categories(`value`: Output<MetadataCategoriesArgs>) {
        this.categories = value
    }

    /**
     * @param value The package id
     */
    @JvmName("xlonvwgykklumfvq")
    public suspend fun contentId(`value`: Output<String>) {
        this.contentId = value
    }

    /**
     * @param value The package kind
     */
    @JvmName("ruiodvwsrfepgqwi")
    public suspend fun contentKind(`value`: Output<Either<String, PackageKind>>) {
        this.contentKind = value
    }

    /**
     * @param value The version of the content schema.
     */
    @JvmName("vsubypupwppkrisa")
    public suspend fun contentSchemaVersion(`value`: Output<String>) {
        this.contentSchemaVersion = value
    }

    /**
     * @param value The support tier of the package
     */
    @JvmName("hxmlsmbcwayatodp")
    public suspend fun dependencies(`value`: Output<MetadataDependenciesArgs>) {
        this.dependencies = value
    }

    /**
     * @param value The description of the package
     */
    @JvmName("kvrsfdajrspltvxh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name of the package
     */
    @JvmName("dtudkhuxkiiilncu")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value first publish date package item
     */
    @JvmName("evmyibrburvtkeeg")
    public suspend fun firstPublishDate(`value`: Output<String>) {
        this.firstPublishDate = value
    }

    /**
     * @param value the icon identifier. this id can later be fetched from the content metadata
     */
    @JvmName("srkmydffbtypgxxa")
    public suspend fun icon(`value`: Output<String>) {
        this.icon = value
    }

    /**
     * @param value Flag indicates if this package is among the featured list.
     */
    @JvmName("vposscghuirlmyhd")
    public suspend fun isFeatured(`value`: Output<Either<String, Flag>>) {
        this.isFeatured = value
    }

    /**
     * @param value Flag indicates if this is a newly published package.
     */
    @JvmName("jdvuvntcmbcriksa")
    public suspend fun isNew(`value`: Output<Either<String, Flag>>) {
        this.isNew = value
    }

    /**
     * @param value Flag indicates if this package is in preview.
     */
    @JvmName("byhdeublyujjtaep")
    public suspend fun isPreview(`value`: Output<Either<String, Flag>>) {
        this.isPreview = value
    }

    /**
     * @param value last publish date for the package item
     */
    @JvmName("dcceycjmivytfrdg")
    public suspend fun lastPublishDate(`value`: Output<String>) {
        this.lastPublishDate = value
    }

    /**
     * @param value package Id
     */
    @JvmName("mhnauwjfdalyovba")
    public suspend fun packageId(`value`: Output<String>) {
        this.packageId = value
    }

    /**
     * @param value Providers for the package item
     */
    @JvmName("bvhrcxxrtooiqxxj")
    public suspend fun providers(`value`: Output<List<String>>) {
        this.providers = value
    }

    @JvmName("bqhovqbhotwsvynp")
    public suspend fun providers(vararg values: Output<String>) {
        this.providers = Output.all(values.asList())
    }

    /**
     * @param values Providers for the package item
     */
    @JvmName("ayyraepmpofpnnmj")
    public suspend fun providers(values: List<Output<String>>) {
        this.providers = Output.all(values)
    }

    /**
     * @param value The publisher display name of the package
     */
    @JvmName("sdbdjxbqmvvhtjdd")
    public suspend fun publisherDisplayName(`value`: Output<String>) {
        this.publisherDisplayName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cvmljuvavhgkmcdy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The source of the package
     */
    @JvmName("wywnqhbshexcusvk")
    public suspend fun source(`value`: Output<MetadataSourceArgs>) {
        this.source = value
    }

    /**
     * @param value The support tier of the package
     */
    @JvmName("xuvdlbqlojmuxmcr")
    public suspend fun support(`value`: Output<MetadataSupportArgs>) {
        this.support = value
    }

    /**
     * @param value the tactics the resource covers
     */
    @JvmName("cukscusavcvdxgeo")
    public suspend fun threatAnalysisTactics(`value`: Output<List<String>>) {
        this.threatAnalysisTactics = value
    }

    @JvmName("iykgurudpvytkace")
    public suspend fun threatAnalysisTactics(vararg values: Output<String>) {
        this.threatAnalysisTactics = Output.all(values.asList())
    }

    /**
     * @param values the tactics the resource covers
     */
    @JvmName("kdajxgasiedwjjdt")
    public suspend fun threatAnalysisTactics(values: List<Output<String>>) {
        this.threatAnalysisTactics = Output.all(values)
    }

    /**
     * @param value the techniques the resource covers, these have to be aligned with the tactics being used
     */
    @JvmName("qlwplyxtlddsovoj")
    public suspend fun threatAnalysisTechniques(`value`: Output<List<String>>) {
        this.threatAnalysisTechniques = value
    }

    @JvmName("oeknjihyydnsbcxj")
    public suspend fun threatAnalysisTechniques(vararg values: Output<String>) {
        this.threatAnalysisTechniques = Output.all(values.asList())
    }

    /**
     * @param values the techniques the resource covers, these have to be aligned with the tactics being used
     */
    @JvmName("emogirxqdltjjgka")
    public suspend fun threatAnalysisTechniques(values: List<Output<String>>) {
        this.threatAnalysisTechniques = Output.all(values)
    }

    /**
     * @param value the latest version number of the package
     */
    @JvmName("rvlfdwcmkhoayxwd")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("oeglfpfcijfwprce")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The author of the package
     */
    @JvmName("ylcvrnthmfpaxeny")
    public suspend fun author(`value`: MetadataAuthorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.author = mapped
    }

    /**
     * @param argument The author of the package
     */
    @JvmName("hvknckjtgflrhbqw")
    public suspend fun author(argument: suspend MetadataAuthorArgsBuilder.() -> Unit) {
        val toBeMapped = MetadataAuthorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.author = mapped
    }

    /**
     * @param value The categories of the package
     */
    @JvmName("flcmnfnvfaomimgf")
    public suspend fun categories(`value`: MetadataCategoriesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    /**
     * @param argument The categories of the package
     */
    @JvmName("wurwidofwlvhwujy")
    public suspend fun categories(argument: suspend MetadataCategoriesArgsBuilder.() -> Unit) {
        val toBeMapped = MetadataCategoriesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.categories = mapped
    }

    /**
     * @param value The package id
     */
    @JvmName("nvnxahoyfcuqtrmu")
    public suspend fun contentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentId = mapped
    }

    /**
     * @param value The package kind
     */
    @JvmName("gydwhdonogulehbb")
    public suspend fun contentKind(`value`: Either<String, PackageKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentKind = mapped
    }

    /**
     * @param value The package kind
     */
    @JvmName("rwbmiwgobtnmasmo")
    public fun contentKind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PackageKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentKind = mapped
    }

    /**
     * @param value The package kind
     */
    @JvmName("rugmvrtqsqddiuyu")
    public fun contentKind(`value`: PackageKind) {
        val toBeMapped = Either.ofRight<String, PackageKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentKind = mapped
    }

    /**
     * @param value The version of the content schema.
     */
    @JvmName("qcrhgicycjkifheq")
    public suspend fun contentSchemaVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentSchemaVersion = mapped
    }

    /**
     * @param value The support tier of the package
     */
    @JvmName("qbwiqorfbofjbddk")
    public suspend fun dependencies(`value`: MetadataDependenciesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependencies = mapped
    }

    /**
     * @param argument The support tier of the package
     */
    @JvmName("gfyxvoouqeitobhg")
    public suspend fun dependencies(argument: suspend MetadataDependenciesArgsBuilder.() -> Unit) {
        val toBeMapped = MetadataDependenciesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dependencies = mapped
    }

    /**
     * @param value The description of the package
     */
    @JvmName("nqihtmxrieetlqta")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name of the package
     */
    @JvmName("qajsevgvjgqrxbdd")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value first publish date package item
     */
    @JvmName("blvmfgqbmaqpmcck")
    public suspend fun firstPublishDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstPublishDate = mapped
    }

    /**
     * @param value the icon identifier. this id can later be fetched from the content metadata
     */
    @JvmName("luvfbnmopbcsmdqv")
    public suspend fun icon(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.icon = mapped
    }

    /**
     * @param value Flag indicates if this package is among the featured list.
     */
    @JvmName("dlltgbfmjvfjqdip")
    public suspend fun isFeatured(`value`: Either<String, Flag>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isFeatured = mapped
    }

    /**
     * @param value Flag indicates if this package is among the featured list.
     */
    @JvmName("ymnrskpjqstyurwa")
    public fun isFeatured(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Flag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isFeatured = mapped
    }

    /**
     * @param value Flag indicates if this package is among the featured list.
     */
    @JvmName("legyauxbvnyejnhb")
    public fun isFeatured(`value`: Flag) {
        val toBeMapped = Either.ofRight<String, Flag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isFeatured = mapped
    }

    /**
     * @param value Flag indicates if this is a newly published package.
     */
    @JvmName("ewkmtpdyajayyuqf")
    public suspend fun isNew(`value`: Either<String, Flag>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isNew = mapped
    }

    /**
     * @param value Flag indicates if this is a newly published package.
     */
    @JvmName("nqapoxubuvgbhkky")
    public fun isNew(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Flag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isNew = mapped
    }

    /**
     * @param value Flag indicates if this is a newly published package.
     */
    @JvmName("dlgisgdvfnaugmql")
    public fun isNew(`value`: Flag) {
        val toBeMapped = Either.ofRight<String, Flag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isNew = mapped
    }

    /**
     * @param value Flag indicates if this package is in preview.
     */
    @JvmName("lrfyteaudhgagvac")
    public suspend fun isPreview(`value`: Either<String, Flag>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPreview = mapped
    }

    /**
     * @param value Flag indicates if this package is in preview.
     */
    @JvmName("jxnapniddxqtbdku")
    public fun isPreview(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Flag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isPreview = mapped
    }

    /**
     * @param value Flag indicates if this package is in preview.
     */
    @JvmName("jcdutfqywbnbvwip")
    public fun isPreview(`value`: Flag) {
        val toBeMapped = Either.ofRight<String, Flag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isPreview = mapped
    }

    /**
     * @param value last publish date for the package item
     */
    @JvmName("umhtapbfgvkigepf")
    public suspend fun lastPublishDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastPublishDate = mapped
    }

    /**
     * @param value package Id
     */
    @JvmName("rtptveriwsiylput")
    public suspend fun packageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageId = mapped
    }

    /**
     * @param value Providers for the package item
     */
    @JvmName("pbkmjqotplrmtdjw")
    public suspend fun providers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providers = mapped
    }

    /**
     * @param values Providers for the package item
     */
    @JvmName("nxyrlrykxiodqkrj")
    public suspend fun providers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providers = mapped
    }

    /**
     * @param value The publisher display name of the package
     */
    @JvmName("hvhpcugbnawrcvce")
    public suspend fun publisherDisplayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherDisplayName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gtkqawbffguardep")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The source of the package
     */
    @JvmName("mgjowiufsjkxjvfp")
    public suspend fun source(`value`: MetadataSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument The source of the package
     */
    @JvmName("jhmxdhuylfxjgdhy")
    public suspend fun source(argument: suspend MetadataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = MetadataSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value The support tier of the package
     */
    @JvmName("mtnacxnssnfminko")
    public suspend fun support(`value`: MetadataSupportArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.support = mapped
    }

    /**
     * @param argument The support tier of the package
     */
    @JvmName("dmhynaxgkqvkbbix")
    public suspend fun support(argument: suspend MetadataSupportArgsBuilder.() -> Unit) {
        val toBeMapped = MetadataSupportArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.support = mapped
    }

    /**
     * @param value the tactics the resource covers
     */
    @JvmName("rbgsrxfngmbllodw")
    public suspend fun threatAnalysisTactics(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatAnalysisTactics = mapped
    }

    /**
     * @param values the tactics the resource covers
     */
    @JvmName("drbkmgmswwywokdq")
    public suspend fun threatAnalysisTactics(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatAnalysisTactics = mapped
    }

    /**
     * @param value the techniques the resource covers, these have to be aligned with the tactics being used
     */
    @JvmName("ufclclwnjqxaekli")
    public suspend fun threatAnalysisTechniques(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatAnalysisTechniques = mapped
    }

    /**
     * @param values the techniques the resource covers, these have to be aligned with the tactics being used
     */
    @JvmName("ktldjakhektujwoe")
    public suspend fun threatAnalysisTechniques(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatAnalysisTechniques = mapped
    }

    /**
     * @param value the latest version number of the package
     */
    @JvmName("vlojbhqplbotgsfb")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("faawrosdwycfcfwe")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ContentPackageArgs = ContentPackageArgs(
        author = author,
        categories = categories,
        contentId = contentId,
        contentKind = contentKind,
        contentSchemaVersion = contentSchemaVersion,
        dependencies = dependencies,
        description = description,
        displayName = displayName,
        firstPublishDate = firstPublishDate,
        icon = icon,
        isFeatured = isFeatured,
        isNew = isNew,
        isPreview = isPreview,
        lastPublishDate = lastPublishDate,
        packageId = packageId,
        providers = providers,
        publisherDisplayName = publisherDisplayName,
        resourceGroupName = resourceGroupName,
        source = source,
        support = support,
        threatAnalysisTactics = threatAnalysisTactics,
        threatAnalysisTechniques = threatAnalysisTechniques,
        version = version,
        workspaceName = workspaceName,
    )
}
