@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataAuthorResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataCategoriesResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataDependenciesResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataSourceResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataSupportResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataAuthorResponse.Companion.toKotlin as metadataAuthorResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataCategoriesResponse.Companion.toKotlin as metadataCategoriesResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataDependenciesResponse.Companion.toKotlin as metadataDependenciesResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataSourceResponse.Companion.toKotlin as metadataSourceResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataSupportResponse.Companion.toKotlin as metadataSupportResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ContentTemplate].
 */
@PulumiTagMarker
public class ContentTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContentTemplateArgs = ContentTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContentTemplateArgsBuilder.() -> Unit) {
        val builder = ContentTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ContentTemplate {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.ContentTemplate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ContentTemplate(builtJavaResource)
    }
}

/**
 * Template resource definition.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### Get a template.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contentTemplate = new AzureNative.SecurityInsights.ContentTemplate("contentTemplate", new()
 *     {
 *         Author = new AzureNative.SecurityInsights.Inputs.MetadataAuthorArgs
 *         {
 *             Email = "support@microsoft.com",
 *             Name = "Microsoft",
 *         },
 *         ContentId = "8365ebfe-a381-45b7-ad08-7d818070e11f",
 *         ContentKind = "AnalyticsRule",
 *         DisplayName = "API Protection workbook template",
 *         MainTemplate =
 *         {
 *             { "$schema", "https://schema.management.azure.com/schemas/2019-04-01/deploymentTemplate.json#" },
 *             { "contentVersion", "1.0.1" },
 *             { "resources", new[]
 *             {
 *                 {
 *                     { "apiVersion", "2022-04-01-preview" },
 *                     { "kind", "Scheduled" },
 *                     { "location", "[parameters('workspace-location')]" },
 *                     { "name", "8365ebfe-a381-45b7-ad08-7d818070e11f" },
 *                     { "properties",
 *                     {
 *                         { "description", "Creates an incident when a large number of Critical/High severity CrowdStrike Falcon sensor detections is triggered by a single user" },
 *                         { "displayName", "Critical or High Severity Detections by User" },
 *                         { "enabled", false },
 *                         { "query", "..." },
 *                         { "queryFrequency", "PT1H" },
 *                         { "queryPeriod", "PT1H" },
 *                         { "severity", "High" },
 *                         { "status", "Available" },
 *                         { "suppressionDuration", "PT1H" },
 *                         { "suppressionEnabled", false },
 *                         { "triggerOperator", "GreaterThan" },
 *                         { "triggerThreshold", 0 },
 *                     } },
 *                     { "type", "Microsoft.SecurityInsights/AlertRuleTemplates" },
 *                 },
 *                 {
 *                     { "apiVersion", "2022-01-01-preview" },
 *                     { "name", "[concat(parameters('workspace'),'/Microsoft.SecurityInsights/',concat('AnalyticsRule-', last(split([resourceId('Microsoft.SecurityInsights/AlertRuleTemplates', 8365ebfe-a381-45b7-ad08-7d818070e11f)],'/'))))]" },
 *                     { "properties",
 *                     {
 *                         { "author",
 *                         {
 *                             { "email", "support@microsoft.com" },
 *                             { "name", "Microsoft" },
 *                         } },
 *                         { "contentId", "4465ebde-b381-45f7-ad08-7d818070a11c" },
 *                         { "description", "CrowdStrike Falcon Endpoint Protection Analytics Rule 1" },
 *                         { "kind", "AnalyticsRule" },
 *                         { "parentId", "[resourceId('Microsoft.SecurityInsights/AlertRuleTemplates', 8365ebfe-a381-45b7-ad08-7d818070e11f)]" },
 *                         { "source",
 *                         {
 *                             { "kind", "Solution" },
 *                             { "name", "str" },
 *                             { "sourceId", "str.azure-sentinel-solution-str" },
 *                         } },
 *                         { "support",
 *                         {
 *                             { "email", "support@microsoft.com" },
 *                             { "link", "https://support.microsoft.com/" },
 *                             { "name", "Microsoft Corporation" },
 *                             { "tier", "Microsoft" },
 *                         } },
 *                         { "version", "1.0.0" },
 *                     } },
 *                     { "type", "Microsoft.OperationalInsights/workspaces/providers/metadata" },
 *                 },
 *             } },
 *         },
 *         PackageId = "str.azure-sentinel-solution-str",
 *         PackageKind = "Solution",
 *         PackageName = "str",
 *         ResourceGroupName = "myRg",
 *         Source = new AzureNative.SecurityInsights.Inputs.MetadataSourceArgs
 *         {
 *             Kind = "Solution",
 *             Name = "str",
 *             SourceId = "str.azure-sentinel-solution-str",
 *         },
 *         Support = new AzureNative.SecurityInsights.Inputs.MetadataSupportArgs
 *         {
 *             Email = "support@microsoft.com",
 *             Link = "https://support.microsoft.com/",
 *             Name = "Microsoft Corporation",
 *             Tier = "Microsoft",
 *         },
 *         TemplateId = "str.azure-sentinel-solution-str",
 *         Version = "1.0.1",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewContentTemplate(ctx, "contentTemplate", &securityinsights.ContentTemplateArgs{
 * 			Author: &securityinsights.MetadataAuthorArgs{
 * 				Email: pulumi.String("support@microsoft.com"),
 * 				Name:  pulumi.String("Microsoft"),
 * 			},
 * 			ContentId:   pulumi.String("8365ebfe-a381-45b7-ad08-7d818070e11f"),
 * 			ContentKind: pulumi.String("AnalyticsRule"),
 * 			DisplayName: pulumi.String("API Protection workbook template"),
 * 			MainTemplate: pulumi.Any{
 * 				Schema:         "https://schema.management.azure.com/schemas/2019-04-01/deploymentTemplate.json#",
 * 				ContentVersion: "1.0.1",
 * 				Resources: []interface{}{
 * 					map[string]interface{}{
 * 						"apiVersion": "2022-04-01-preview",
 * 						"kind":       "Scheduled",
 * 						"location":   "[parameters('workspace-location')]",
 * 						"name":       "8365ebfe-a381-45b7-ad08-7d818070e11f",
 * 						"properties": map[string]interface{}{
 * 							"description":         "Creates an incident when a large number of Critical/High severity CrowdStrike Falcon sensor detections is triggered by a single user",
 * 							"displayName":         "Critical or High Severity Detections by User",
 * 							"enabled":             false,
 * 							"query":               "...",
 * 							"queryFrequency":      "PT1H",
 * 							"queryPeriod":         "PT1H",
 * 							"severity":            "High",
 * 							"status":              "Available",
 * 							"suppressionDuration": "PT1H",
 * 							"suppressionEnabled":  false,
 * 							"triggerOperator":     "GreaterThan",
 * 							"triggerThreshold":    0,
 * 						},
 * 						"type": "Microsoft.SecurityInsights/AlertRuleTemplates",
 * 					},
 * 					map[string]interface{}{
 * 						"apiVersion": "2022-01-01-preview",
 * 						"name":       "[concat(parameters('workspace'),'/Microsoft.SecurityInsights/',concat('AnalyticsRule-', last(split([resourceId('Microsoft.SecurityInsights/AlertRuleTemplates', 8365ebfe-a381-45b7-ad08-7d818070e11f)],'/'))))]",
 * 						"properties": map[string]interface{}{
 * 							"author": map[string]interface{}{
 * 								"email": "support@microsoft.com",
 * 								"name":  "Microsoft",
 * 							},
 * 							"contentId":   "4465ebde-b381-45f7-ad08-7d818070a11c",
 * 							"description": "CrowdStrike Falcon Endpoint Protection Analytics Rule 1",
 * 							"kind":        "AnalyticsRule",
 * 							"parentId":    "[resourceId('Microsoft.SecurityInsights/AlertRuleTemplates', 8365ebfe-a381-45b7-ad08-7d818070e11f)]",
 * 							"source": map[string]interface{}{
 * 								"kind":     "Solution",
 * 								"name":     "str",
 * 								"sourceId": "str.azure-sentinel-solution-str",
 * 							},
 * 							"support": map[string]interface{}{
 * 								"email": "support@microsoft.com",
 * 								"link":  "https://support.microsoft.com/",
 * 								"name":  "Microsoft Corporation",
 * 								"tier":  "Microsoft",
 * 							},
 * 							"version": "1.0.0",
 * 						},
 * 						"type": "Microsoft.OperationalInsights/workspaces/providers/metadata",
 * 					},
 * 				},
 * 			},
 * 			PackageId:         pulumi.String("str.azure-sentinel-solution-str"),
 * 			PackageKind:       pulumi.String("Solution"),
 * 			PackageName:       pulumi.String("str"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Source: &securityinsights.MetadataSourceArgs{
 * 				Kind:     pulumi.String("Solution"),
 * 				Name:     pulumi.String("str"),
 * 				SourceId: pulumi.String("str.azure-sentinel-solution-str"),
 * 			},
 * 			Support: &securityinsights.MetadataSupportArgs{
 * 				Email: pulumi.String("support@microsoft.com"),
 * 				Link:  pulumi.String("https://support.microsoft.com/"),
 * 				Name:  pulumi.String("Microsoft Corporation"),
 * 				Tier:  pulumi.String("Microsoft"),
 * 			},
 * 			TemplateId:    pulumi.String("str.azure-sentinel-solution-str"),
 * 			Version:       pulumi.String("1.0.1"),
 * 			WorkspaceName: pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.ContentTemplate;
 * import com.pulumi.azurenative.securityinsights.ContentTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contentTemplate = new ContentTemplate("contentTemplate", ContentTemplateArgs.builder()
 *             .author(Map.ofEntries(
 *                 Map.entry("email", "support@microsoft.com"),
 *                 Map.entry("name", "Microsoft")
 *             ))
 *             .contentId("8365ebfe-a381-45b7-ad08-7d818070e11f")
 *             .contentKind("AnalyticsRule")
 *             .displayName("API Protection workbook template")
 *             .mainTemplate(Map.ofEntries(
 *                 Map.entry("$schema", "https://schema.management.azure.com/schemas/2019-04-01/deploymentTemplate.json#"),
 *                 Map.entry("contentVersion", "1.0.1"),
 *                 Map.entry("resources",
 *                     Map.ofEntries(
 *                         Map.entry("apiVersion", "2022-04-01-preview"),
 *                         Map.entry("kind", "Scheduled"),
 *                         Map.entry("location", "[parameters('workspace-location')]"),
 *                         Map.entry("name", "8365ebfe-a381-45b7-ad08-7d818070e11f"),
 *                         Map.entry("properties", Map.ofEntries(
 *                             Map.entry("description", "Creates an incident when a large number of Critical/High severity CrowdStrike Falcon sensor detections is triggered by a single user"),
 *                             Map.entry("displayName", "Critical or High Severity Detections by User"),
 *                             Map.entry("enabled", false),
 *                             Map.entry("query", "..."),
 *                             Map.entry("queryFrequency", "PT1H"),
 *                             Map.entry("queryPeriod", "PT1H"),
 *                             Map.entry("severity", "High"),
 *                             Map.entry("status", "Available"),
 *                             Map.entry("suppressionDuration", "PT1H"),
 *                             Map.entry("suppressionEnabled", false),
 *                             Map.entry("triggerOperator", "GreaterThan"),
 *                             Map.entry("triggerThreshold", 0)
 *                         )),
 *                         Map.entry("type", "Microsoft.SecurityInsights/AlertRuleTemplates")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("apiVersion", "2022-01-01-preview"),
 *                         Map.entry("name", "[concat(parameters('workspace'),'/Microsoft.SecurityInsights/',concat('AnalyticsRule-', last(split([resourceId('Microsoft.SecurityInsights/AlertRuleTemplates', 8365ebfe-a381-45b7-ad08-7d818070e11f)],'/'))))]"),
 *                         Map.entry("properties", Map.ofEntries(
 *                             Map.entry("author", Map.ofEntries(
 *                                 Map.entry("email", "support@microsoft.com"),
 *                                 Map.entry("name", "Microsoft")
 *                             )),
 *                             Map.entry("contentId", "4465ebde-b381-45f7-ad08-7d818070a11c"),
 *                             Map.entry("description", "CrowdStrike Falcon Endpoint Protection Analytics Rule 1"),
 *                             Map.entry("kind", "AnalyticsRule"),
 *                             Map.entry("parentId", "[resourceId('Microsoft.SecurityInsights/AlertRuleTemplates', 8365ebfe-a381-45b7-ad08-7d818070e11f)]"),
 *                             Map.entry("source", Map.ofEntries(
 *                                 Map.entry("kind", "Solution"),
 *                                 Map.entry("name", "str"),
 *                                 Map.entry("sourceId", "str.azure-sentinel-solution-str")
 *                             )),
 *                             Map.entry("support", Map.ofEntries(
 *                                 Map.entry("email", "support@microsoft.com"),
 *                                 Map.entry("link", "https://support.microsoft.com/"),
 *                                 Map.entry("name", "Microsoft Corporation"),
 *                                 Map.entry("tier", "Microsoft")
 *                             )),
 *                             Map.entry("version", "1.0.0")
 *                         )),
 *                         Map.entry("type", "Microsoft.OperationalInsights/workspaces/providers/metadata")
 *                     ))
 *             ))
 *             .packageId("str.azure-sentinel-solution-str")
 *             .packageKind("Solution")
 *             .packageName("str")
 *             .resourceGroupName("myRg")
 *             .source(Map.ofEntries(
 *                 Map.entry("kind", "Solution"),
 *                 Map.entry("name", "str"),
 *                 Map.entry("sourceId", "str.azure-sentinel-solution-str")
 *             ))
 *             .support(Map.ofEntries(
 *                 Map.entry("email", "support@microsoft.com"),
 *                 Map.entry("link", "https://support.microsoft.com/"),
 *                 Map.entry("name", "Microsoft Corporation"),
 *                 Map.entry("tier", "Microsoft")
 *             ))
 *             .templateId("str.azure-sentinel-solution-str")
 *             .version("1.0.1")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:ContentTemplate azuresentinel.azure-sentinel-solution-ciscoumbrella /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentTemplates/{templateId}
 * ```
 */
public class ContentTemplate internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.ContentTemplate,
) : KotlinCustomResource(javaResource, ContentTemplateMapper) {
    /**
     * The creator of the content item.
     */
    public val author: Output<MetadataAuthorResponse>?
        get() = javaResource.author().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    metadataAuthorResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Categories for the item
     */
    public val categories: Output<MetadataCategoriesResponse>?
        get() = javaResource.categories().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    metadataCategoriesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Static ID for the content.  Used to identify dependencies and content from solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic for user-created.  This is the resource name
     */
    public val contentId: Output<String>
        get() = javaResource.contentId().applyValue({ args0 -> args0 })

    /**
     * The kind of content the template is for.
     */
    public val contentKind: Output<String>
        get() = javaResource.contentKind().applyValue({ args0 -> args0 })

    /**
     * Schema version of the content. Can be used to distinguish between different flow based on the schema version
     */
    public val contentSchemaVersion: Output<String>?
        get() = javaResource.contentSchemaVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The custom version of the content. A optional free text
     */
    public val customVersion: Output<String>?
        get() = javaResource.customVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex formats.
     */
    public val dependencies: Output<MetadataDependenciesResponse>?
        get() = javaResource.dependencies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    metadataDependenciesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The display name of the template
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * first publish date content item
     */
    public val firstPublishDate: Output<String>?
        get() = javaResource.firstPublishDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * the icon identifier. this id can later be fetched from the content metadata
     */
    public val icon: Output<String>?
        get() = javaResource.icon().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * last publish date for the content item
     */
    public val lastPublishDate: Output<String>?
        get() = javaResource.lastPublishDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The JSON of the ARM template to deploy active content
     */
    public val mainTemplate: Output<Any>?
        get() = javaResource.mainTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * the package Id contains this template
     */
    public val packageId: Output<String>
        get() = javaResource.packageId().applyValue({ args0 -> args0 })

    /**
     * the packageKind of the package contains this template
     */
    public val packageKind: Output<String>?
        get() = javaResource.packageKind().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * the name of the package contains this template
     */
    public val packageName: Output<String>?
        get() = javaResource.packageName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * preview image file names. These will be taken from the solution artifacts
     */
    public val previewImages: Output<List<String>>?
        get() = javaResource.previewImages().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * preview image file names. These will be taken from the solution artifacts. used for dark theme support
     */
    public val previewImagesDark: Output<List<String>>?
        get() = javaResource.previewImagesDark().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Providers for the content item
     */
    public val providers: Output<List<String>>?
        get() = javaResource.providers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Source of the content.  This is where/how it was created.
     */
    public val source: Output<MetadataSourceResponse>
        get() = javaResource.source().applyValue({ args0 ->
            args0.let({ args0 ->
                metadataSourceResponseToKotlin(args0)
            })
        })

    /**
     * Support information for the template - type, name, contact information
     */
    public val support: Output<MetadataSupportResponse>?
        get() = javaResource.support().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    metadataSupportResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * the tactics the resource covers
     */
    public val threatAnalysisTactics: Output<List<String>>?
        get() = javaResource.threatAnalysisTactics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * the techniques the resource covers, these have to be aligned with the tactics being used
     */
    public val threatAnalysisTechniques: Output<List<String>>?
        get() = javaResource.threatAnalysisTechniques().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Version of the content.  Default and recommended format is numeric (e.g. 1, 1.0, 1.0.0, 1.0.0.0), following ARM metadata best practices.  Can also be any string, but then we cannot guarantee any version checks
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object ContentTemplateMapper : ResourceMapper<ContentTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.ContentTemplate::class == javaResource::class

    override fun map(javaResource: Resource): ContentTemplate = ContentTemplate(
        javaResource as
            com.pulumi.azurenative.securityinsights.ContentTemplate,
    )
}

/**
 * @see [ContentTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContentTemplate].
 */
public suspend fun contentTemplate(
    name: String,
    block: suspend ContentTemplateResourceBuilder.() -> Unit,
): ContentTemplate {
    val builder = ContentTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContentTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun contentTemplate(name: String): ContentTemplate {
    val builder = ContentTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
