@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.FileMetadataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.ValidationErrorResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.securityinsights.kotlin.outputs.FileMetadataResponse.Companion.toKotlin as fileMetadataResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.ValidationErrorResponse.Companion.toKotlin as validationErrorResponseToKotlin

/**
 * Builder for [FileImport].
 */
@PulumiTagMarker
public class FileImportResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FileImportArgs = FileImportArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FileImportArgsBuilder.() -> Unit) {
        val builder = FileImportArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FileImport {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.FileImport(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FileImport(builtJavaResource)
    }
}

/**
 * Represents a file import in Azure Security Insights.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### Create a file import.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileImport = new AzureNative.SecurityInsights.FileImport("fileImport", new()
 *     {
 *         ContentType = "StixIndicator",
 *         FileImportId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         ImportFile = new AzureNative.SecurityInsights.Inputs.FileMetadataArgs
 *         {
 *             FileFormat = "JSON",
 *             FileName = "myFile.json",
 *             FileSize = 4653,
 *         },
 *         IngestionMode = "IngestAnyValidRecords",
 *         ResourceGroupName = "myRg",
 *         Source = "mySource",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewFileImport(ctx, "fileImport", &securityinsights.FileImportArgs{
 * 			ContentType:  pulumi.String("StixIndicator"),
 * 			FileImportId: pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			ImportFile: &securityinsights.FileMetadataArgs{
 * 				FileFormat: pulumi.String("JSON"),
 * 				FileName:   pulumi.String("myFile.json"),
 * 				FileSize:   pulumi.Int(4653),
 * 			},
 * 			IngestionMode:     pulumi.String("IngestAnyValidRecords"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Source:            pulumi.String("mySource"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.FileImport;
 * import com.pulumi.azurenative.securityinsights.FileImportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileImport = new FileImport("fileImport", FileImportArgs.builder()
 *             .contentType("StixIndicator")
 *             .fileImportId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .importFile(Map.ofEntries(
 *                 Map.entry("fileFormat", "JSON"),
 *                 Map.entry("fileName", "myFile.json"),
 *                 Map.entry("fileSize", 4653)
 *             ))
 *             .ingestionMode("IngestAnyValidRecords")
 *             .resourceGroupName("myRg")
 *             .source("mySource")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:FileImport 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/fileImports/{fileImportId}
 * ```
 */
public class FileImport internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.FileImport,
) : KotlinCustomResource(javaResource, FileImportMapper) {
    /**
     * The content type of this file.
     */
    public val contentType: Output<String>
        get() = javaResource.contentType().applyValue({ args0 -> args0 })

    /**
     * The time the file was imported.
     */
    public val createdTimeUTC: Output<String>
        get() = javaResource.createdTimeUTC().applyValue({ args0 -> args0 })

    /**
     * Represents the error file (if the import was ingested with errors or failed the validation).
     */
    public val errorFile: Output<FileMetadataResponse>
        get() = javaResource.errorFile().applyValue({ args0 ->
            args0.let({ args0 ->
                fileMetadataResponseToKotlin(args0)
            })
        })

    /**
     * An ordered list of some of the errors that were encountered during validation.
     */
    public val errorsPreview: Output<List<ValidationErrorResponse>>
        get() = javaResource.errorsPreview().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> validationErrorResponseToKotlin(args0) })
            })
        })

    /**
     * The time the files associated with this import are deleted from the storage account.
     */
    public val filesValidUntilTimeUTC: Output<String>
        get() = javaResource.filesValidUntilTimeUTC().applyValue({ args0 -> args0 })

    /**
     * Represents the imported file.
     */
    public val importFile: Output<FileMetadataResponse>
        get() = javaResource.importFile().applyValue({ args0 ->
            args0.let({ args0 ->
                fileMetadataResponseToKotlin(args0)
            })
        })

    /**
     * The time the file import record is soft deleted from the database and history.
     */
    public val importValidUntilTimeUTC: Output<String>
        get() = javaResource.importValidUntilTimeUTC().applyValue({ args0 -> args0 })

    /**
     * The number of records that have been successfully ingested.
     */
    public val ingestedRecordCount: Output<Int>
        get() = javaResource.ingestedRecordCount().applyValue({ args0 -> args0 })

    /**
     * Describes how to ingest the records in the file.
     */
    public val ingestionMode: Output<String>
        get() = javaResource.ingestionMode().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The source for the data in the file.
     */
    public val source: Output<String>
        get() = javaResource.source().applyValue({ args0 -> args0 })

    /**
     * The state of the file import.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The number of records in the file.
     */
    public val totalRecordCount: Output<Int>
        get() = javaResource.totalRecordCount().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The number of records that have passed validation.
     */
    public val validRecordCount: Output<Int>
        get() = javaResource.validRecordCount().applyValue({ args0 -> args0 })
}

public object FileImportMapper : ResourceMapper<FileImport> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.FileImport::class == javaResource::class

    override fun map(javaResource: Resource): FileImport = FileImport(
        javaResource as
            com.pulumi.azurenative.securityinsights.FileImport,
    )
}

/**
 * @see [FileImport].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FileImport].
 */
public suspend fun fileImport(name: String, block: suspend FileImportResourceBuilder.() -> Unit):
    FileImport {
    val builder = FileImportResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FileImport].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fileImport(name: String): FileImport {
    val builder = FileImportResourceBuilder()
    builder.name(name)
    return builder.build()
}
