@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [HuntComment].
 */
@PulumiTagMarker
public class HuntCommentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HuntCommentArgs = HuntCommentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HuntCommentArgsBuilder.() -> Unit) {
        val builder = HuntCommentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): HuntComment {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.HuntComment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HuntComment(builtJavaResource)
    }
}

/**
 * Represents a Hunt Comment in Azure Security Insights
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### Creates or updates a hunt comment.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var huntComment = new AzureNative.SecurityInsights.HuntComment("huntComment", new()
 *     {
 *         HuntCommentId = "2216d0e1-91e3-4902-89fd-d2df8c535096",
 *         HuntId = "163e7b2a-a2ec-4041-aaba-d878a38f265f",
 *         Message = "This is a test comment.",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewHuntComment(ctx, "huntComment", &securityinsights.HuntCommentArgs{
 * 			HuntCommentId:     pulumi.String("2216d0e1-91e3-4902-89fd-d2df8c535096"),
 * 			HuntId:            pulumi.String("163e7b2a-a2ec-4041-aaba-d878a38f265f"),
 * 			Message:           pulumi.String("This is a test comment."),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.HuntComment;
 * import com.pulumi.azurenative.securityinsights.HuntCommentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var huntComment = new HuntComment("huntComment", HuntCommentArgs.builder()
 *             .huntCommentId("2216d0e1-91e3-4902-89fd-d2df8c535096")
 *             .huntId("163e7b2a-a2ec-4041-aaba-d878a38f265f")
 *             .message("This is a test comment.")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:HuntComment 2216d0e1-91e3-4902-89fd-d2df8c123456 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}/comments/{huntCommentId}
 * ```
 */
public class HuntComment internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.HuntComment,
) : KotlinCustomResource(javaResource, HuntCommentMapper) {
    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The message for the comment
     */
    public val message: Output<String>
        get() = javaResource.message().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object HuntCommentMapper : ResourceMapper<HuntComment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.HuntComment::class == javaResource::class

    override fun map(javaResource: Resource): HuntComment = HuntComment(
        javaResource as
            com.pulumi.azurenative.securityinsights.HuntComment,
    )
}

/**
 * @see [HuntComment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HuntComment].
 */
public suspend fun huntComment(name: String, block: suspend HuntCommentResourceBuilder.() -> Unit):
    HuntComment {
    val builder = HuntCommentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HuntComment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun huntComment(name: String): HuntComment {
    val builder = HuntCommentResourceBuilder()
    builder.name(name)
    return builder.build()
}
