@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.IncidentCommentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents an incident comment
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### Creates or updates an incident comment.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var incidentComment = new AzureNative.SecurityInsights.IncidentComment("incidentComment", new()
 *     {
 *         IncidentCommentId = "4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014",
 *         IncidentId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         Message = "Some message",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewIncidentComment(ctx, "incidentComment", &securityinsights.IncidentCommentArgs{
 * 			IncidentCommentId: pulumi.String("4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014"),
 * 			IncidentId:        pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			Message:           pulumi.String("Some message"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.IncidentComment;
 * import com.pulumi.azurenative.securityinsights.IncidentCommentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var incidentComment = new IncidentComment("incidentComment", IncidentCommentArgs.builder()
 *             .incidentCommentId("4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014")
 *             .incidentId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .message("Some message")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:IncidentComment 4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}/comments/{incidentCommentId}
 * ```
 * @property incidentCommentId Incident comment ID
 * @property incidentId Incident ID
 * @property message The comment message
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class IncidentCommentArgs(
    public val incidentCommentId: Output<String>? = null,
    public val incidentId: Output<String>? = null,
    public val message: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.IncidentCommentArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.IncidentCommentArgs =
        com.pulumi.azurenative.securityinsights.IncidentCommentArgs.builder()
            .incidentCommentId(incidentCommentId?.applyValue({ args0 -> args0 }))
            .incidentId(incidentId?.applyValue({ args0 -> args0 }))
            .message(message?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IncidentCommentArgs].
 */
@PulumiTagMarker
public class IncidentCommentArgsBuilder internal constructor() {
    private var incidentCommentId: Output<String>? = null

    private var incidentId: Output<String>? = null

    private var message: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Incident comment ID
     */
    @JvmName("mwcojeieicuaaiym")
    public suspend fun incidentCommentId(`value`: Output<String>) {
        this.incidentCommentId = value
    }

    /**
     * @param value Incident ID
     */
    @JvmName("gfsctdwvwtjyewuy")
    public suspend fun incidentId(`value`: Output<String>) {
        this.incidentId = value
    }

    /**
     * @param value The comment message
     */
    @JvmName("uqcwhmnlvqwooakb")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("onuddboivlxbyion")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("wcwhyddurgrbeyab")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Incident comment ID
     */
    @JvmName("jemckxlgvyyxtuux")
    public suspend fun incidentCommentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incidentCommentId = mapped
    }

    /**
     * @param value Incident ID
     */
    @JvmName("ecgpnxwuuoejaycn")
    public suspend fun incidentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incidentId = mapped
    }

    /**
     * @param value The comment message
     */
    @JvmName("eabwvvaptouubusa")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oqjyhqxdaneulbpf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("stumvnagnkpvutul")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): IncidentCommentArgs = IncidentCommentArgs(
        incidentCommentId = incidentCommentId,
        incidentId = incidentId,
        message = message,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
