@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.MetadataArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataAuthorArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataAuthorArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataCategoriesArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataCategoriesArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataDependenciesArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataDependenciesArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataSourceArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataSourceArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataSupportArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataSupportArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Metadata resource definition.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2023-02-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### Create/update minimal metadata.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metadata = new AzureNative.SecurityInsights.Metadata("metadata", new()
 *     {
 *         ContentId = "c00ee137-7475-47c8-9cce-ec6f0f1bedd0",
 *         Kind = "AnalyticsRule",
 *         MetadataName = "metadataName",
 *         ParentId = "/subscriptions/2e1dc338-d04d-4443-b721-037eff4fdcac/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/ruleName",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewMetadata(ctx, "metadata", &securityinsights.MetadataArgs{
 * 			ContentId:         pulumi.String("c00ee137-7475-47c8-9cce-ec6f0f1bedd0"),
 * 			Kind:              pulumi.String("AnalyticsRule"),
 * 			MetadataName:      pulumi.String("metadataName"),
 * 			ParentId:          pulumi.String("/subscriptions/2e1dc338-d04d-4443-b721-037eff4fdcac/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/ruleName"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.Metadata;
 * import com.pulumi.azurenative.securityinsights.MetadataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metadata = new Metadata("metadata", MetadataArgs.builder()
 *             .contentId("c00ee137-7475-47c8-9cce-ec6f0f1bedd0")
 *             .kind("AnalyticsRule")
 *             .metadataName("metadataName")
 *             .parentId("/subscriptions/2e1dc338-d04d-4443-b721-037eff4fdcac/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/ruleName")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:Metadata metadataName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/metadata/{metadataName}
 * ```
 * @property author The creator of the content item.
 * @property categories Categories for the solution content item
 * @property contentId Static ID for the content.  Used to identify dependencies and content from solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic for user-created.  This is the resource name
 * @property contentSchemaVersion Schema version of the content. Can be used to distinguish between different flow based on the schema version
 * @property customVersion The custom version of the content. A optional free text
 * @property dependencies Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex formats.
 * @property firstPublishDate first publish date solution content item
 * @property icon the icon identifier. this id can later be fetched from the solution template
 * @property kind The kind of content the metadata is for.
 * @property lastPublishDate last publish date for the solution content item
 * @property metadataName The Metadata name.
 * @property parentId Full parent resource ID of the content item the metadata is for.  This is the full resource ID including the scope (subscription and resource group)
 * @property previewImages preview image file names. These will be taken from the solution artifacts
 * @property previewImagesDark preview image file names. These will be taken from the solution artifacts. used for dark theme support
 * @property providers Providers for the solution content item
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property source Source of the content.  This is where/how it was created.
 * @property support Support information for the metadata - type, name, contact information
 * @property threatAnalysisTactics the tactics the resource covers
 * @property threatAnalysisTechniques the techniques the resource covers, these have to be aligned with the tactics being used
 * @property version Version of the content.  Default and recommended format is numeric (e.g. 1, 1.0, 1.0.0, 1.0.0.0), following ARM template best practices.  Can also be any string, but then we cannot guarantee any version checks
 * @property workspaceName The name of the workspace.
 */
public data class MetadataArgs(
    public val author: Output<MetadataAuthorArgs>? = null,
    public val categories: Output<MetadataCategoriesArgs>? = null,
    public val contentId: Output<String>? = null,
    public val contentSchemaVersion: Output<String>? = null,
    public val customVersion: Output<String>? = null,
    public val dependencies: Output<MetadataDependenciesArgs>? = null,
    public val firstPublishDate: Output<String>? = null,
    public val icon: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val lastPublishDate: Output<String>? = null,
    public val metadataName: Output<String>? = null,
    public val parentId: Output<String>? = null,
    public val previewImages: Output<List<String>>? = null,
    public val previewImagesDark: Output<List<String>>? = null,
    public val providers: Output<List<String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val source: Output<MetadataSourceArgs>? = null,
    public val support: Output<MetadataSupportArgs>? = null,
    public val threatAnalysisTactics: Output<List<String>>? = null,
    public val threatAnalysisTechniques: Output<List<String>>? = null,
    public val version: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.MetadataArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.MetadataArgs =
        com.pulumi.azurenative.securityinsights.MetadataArgs.builder()
            .author(author?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .categories(categories?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .contentId(contentId?.applyValue({ args0 -> args0 }))
            .contentSchemaVersion(contentSchemaVersion?.applyValue({ args0 -> args0 }))
            .customVersion(customVersion?.applyValue({ args0 -> args0 }))
            .dependencies(dependencies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .firstPublishDate(firstPublishDate?.applyValue({ args0 -> args0 }))
            .icon(icon?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .lastPublishDate(lastPublishDate?.applyValue({ args0 -> args0 }))
            .metadataName(metadataName?.applyValue({ args0 -> args0 }))
            .parentId(parentId?.applyValue({ args0 -> args0 }))
            .previewImages(previewImages?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .previewImagesDark(previewImagesDark?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .providers(providers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .support(support?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .threatAnalysisTactics(threatAnalysisTactics?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .threatAnalysisTechniques(
                threatAnalysisTechniques?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .version(version?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetadataArgs].
 */
@PulumiTagMarker
public class MetadataArgsBuilder internal constructor() {
    private var author: Output<MetadataAuthorArgs>? = null

    private var categories: Output<MetadataCategoriesArgs>? = null

    private var contentId: Output<String>? = null

    private var contentSchemaVersion: Output<String>? = null

    private var customVersion: Output<String>? = null

    private var dependencies: Output<MetadataDependenciesArgs>? = null

    private var firstPublishDate: Output<String>? = null

    private var icon: Output<String>? = null

    private var kind: Output<String>? = null

    private var lastPublishDate: Output<String>? = null

    private var metadataName: Output<String>? = null

    private var parentId: Output<String>? = null

    private var previewImages: Output<List<String>>? = null

    private var previewImagesDark: Output<List<String>>? = null

    private var providers: Output<List<String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var source: Output<MetadataSourceArgs>? = null

    private var support: Output<MetadataSupportArgs>? = null

    private var threatAnalysisTactics: Output<List<String>>? = null

    private var threatAnalysisTechniques: Output<List<String>>? = null

    private var version: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The creator of the content item.
     */
    @JvmName("qxcifabvvfvhxiuv")
    public suspend fun author(`value`: Output<MetadataAuthorArgs>) {
        this.author = value
    }

    /**
     * @param value Categories for the solution content item
     */
    @JvmName("pxsufiiwdsvvywjy")
    public suspend fun categories(`value`: Output<MetadataCategoriesArgs>) {
        this.categories = value
    }

    /**
     * @param value Static ID for the content.  Used to identify dependencies and content from solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic for user-created.  This is the resource name
     */
    @JvmName("xpnkqkoaojjmtxvd")
    public suspend fun contentId(`value`: Output<String>) {
        this.contentId = value
    }

    /**
     * @param value Schema version of the content. Can be used to distinguish between different flow based on the schema version
     */
    @JvmName("leeubqnpbabqoxux")
    public suspend fun contentSchemaVersion(`value`: Output<String>) {
        this.contentSchemaVersion = value
    }

    /**
     * @param value The custom version of the content. A optional free text
     */
    @JvmName("lbugdcauaavapfwg")
    public suspend fun customVersion(`value`: Output<String>) {
        this.customVersion = value
    }

    /**
     * @param value Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex formats.
     */
    @JvmName("cueaspycwoynmwmv")
    public suspend fun dependencies(`value`: Output<MetadataDependenciesArgs>) {
        this.dependencies = value
    }

    /**
     * @param value first publish date solution content item
     */
    @JvmName("rluwiolbqwybyvuk")
    public suspend fun firstPublishDate(`value`: Output<String>) {
        this.firstPublishDate = value
    }

    /**
     * @param value the icon identifier. this id can later be fetched from the solution template
     */
    @JvmName("uimsecfsjcpgtbde")
    public suspend fun icon(`value`: Output<String>) {
        this.icon = value
    }

    /**
     * @param value The kind of content the metadata is for.
     */
    @JvmName("grwjpwgpalffgtsp")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value last publish date for the solution content item
     */
    @JvmName("umlsyybobcoxnaqp")
    public suspend fun lastPublishDate(`value`: Output<String>) {
        this.lastPublishDate = value
    }

    /**
     * @param value The Metadata name.
     */
    @JvmName("vtgajystqrdmajlu")
    public suspend fun metadataName(`value`: Output<String>) {
        this.metadataName = value
    }

    /**
     * @param value Full parent resource ID of the content item the metadata is for.  This is the full resource ID including the scope (subscription and resource group)
     */
    @JvmName("bwivuubniaogeyuj")
    public suspend fun parentId(`value`: Output<String>) {
        this.parentId = value
    }

    /**
     * @param value preview image file names. These will be taken from the solution artifacts
     */
    @JvmName("oqfklrvmtlervuum")
    public suspend fun previewImages(`value`: Output<List<String>>) {
        this.previewImages = value
    }

    @JvmName("trnbhnwpmnhcghnb")
    public suspend fun previewImages(vararg values: Output<String>) {
        this.previewImages = Output.all(values.asList())
    }

    /**
     * @param values preview image file names. These will be taken from the solution artifacts
     */
    @JvmName("qvtastmeifmykgxq")
    public suspend fun previewImages(values: List<Output<String>>) {
        this.previewImages = Output.all(values)
    }

    /**
     * @param value preview image file names. These will be taken from the solution artifacts. used for dark theme support
     */
    @JvmName("oceeqxwsrtwlewpy")
    public suspend fun previewImagesDark(`value`: Output<List<String>>) {
        this.previewImagesDark = value
    }

    @JvmName("dcohaytggayldhmd")
    public suspend fun previewImagesDark(vararg values: Output<String>) {
        this.previewImagesDark = Output.all(values.asList())
    }

    /**
     * @param values preview image file names. These will be taken from the solution artifacts. used for dark theme support
     */
    @JvmName("mthqjhypynrjiwfm")
    public suspend fun previewImagesDark(values: List<Output<String>>) {
        this.previewImagesDark = Output.all(values)
    }

    /**
     * @param value Providers for the solution content item
     */
    @JvmName("omsbntjatvkfxebb")
    public suspend fun providers(`value`: Output<List<String>>) {
        this.providers = value
    }

    @JvmName("ouanxltgolmifkis")
    public suspend fun providers(vararg values: Output<String>) {
        this.providers = Output.all(values.asList())
    }

    /**
     * @param values Providers for the solution content item
     */
    @JvmName("siubsvcjtnesnyud")
    public suspend fun providers(values: List<Output<String>>) {
        this.providers = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("swqiwqbsesantsmj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Source of the content.  This is where/how it was created.
     */
    @JvmName("ahbjoyjfbvggidcd")
    public suspend fun source(`value`: Output<MetadataSourceArgs>) {
        this.source = value
    }

    /**
     * @param value Support information for the metadata - type, name, contact information
     */
    @JvmName("bdcdrlbswhjylcta")
    public suspend fun support(`value`: Output<MetadataSupportArgs>) {
        this.support = value
    }

    /**
     * @param value the tactics the resource covers
     */
    @JvmName("uhlqxvdxmsdmykwp")
    public suspend fun threatAnalysisTactics(`value`: Output<List<String>>) {
        this.threatAnalysisTactics = value
    }

    @JvmName("wuolsqlevyobinps")
    public suspend fun threatAnalysisTactics(vararg values: Output<String>) {
        this.threatAnalysisTactics = Output.all(values.asList())
    }

    /**
     * @param values the tactics the resource covers
     */
    @JvmName("chgdncylrmesxewg")
    public suspend fun threatAnalysisTactics(values: List<Output<String>>) {
        this.threatAnalysisTactics = Output.all(values)
    }

    /**
     * @param value the techniques the resource covers, these have to be aligned with the tactics being used
     */
    @JvmName("aqdfjhgvnrsaihes")
    public suspend fun threatAnalysisTechniques(`value`: Output<List<String>>) {
        this.threatAnalysisTechniques = value
    }

    @JvmName("nnmbbqkkdvsuittk")
    public suspend fun threatAnalysisTechniques(vararg values: Output<String>) {
        this.threatAnalysisTechniques = Output.all(values.asList())
    }

    /**
     * @param values the techniques the resource covers, these have to be aligned with the tactics being used
     */
    @JvmName("iyaovduqjceyrnpf")
    public suspend fun threatAnalysisTechniques(values: List<Output<String>>) {
        this.threatAnalysisTechniques = Output.all(values)
    }

    /**
     * @param value Version of the content.  Default and recommended format is numeric (e.g. 1, 1.0, 1.0.0, 1.0.0.0), following ARM template best practices.  Can also be any string, but then we cannot guarantee any version checks
     */
    @JvmName("wanljlfdkqfmxeii")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("cwcpuulintbivssu")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The creator of the content item.
     */
    @JvmName("jtnwvagehsscnswo")
    public suspend fun author(`value`: MetadataAuthorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.author = mapped
    }

    /**
     * @param argument The creator of the content item.
     */
    @JvmName("jishgefawwfjxtrr")
    public suspend fun author(argument: suspend MetadataAuthorArgsBuilder.() -> Unit) {
        val toBeMapped = MetadataAuthorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.author = mapped
    }

    /**
     * @param value Categories for the solution content item
     */
    @JvmName("oxaupcaixmbnckse")
    public suspend fun categories(`value`: MetadataCategoriesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    /**
     * @param argument Categories for the solution content item
     */
    @JvmName("ewxvtipxovktwwos")
    public suspend fun categories(argument: suspend MetadataCategoriesArgsBuilder.() -> Unit) {
        val toBeMapped = MetadataCategoriesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.categories = mapped
    }

    /**
     * @param value Static ID for the content.  Used to identify dependencies and content from solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic for user-created.  This is the resource name
     */
    @JvmName("ujndaqhxuxtgtxop")
    public suspend fun contentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentId = mapped
    }

    /**
     * @param value Schema version of the content. Can be used to distinguish between different flow based on the schema version
     */
    @JvmName("csifjynjeaubtvah")
    public suspend fun contentSchemaVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentSchemaVersion = mapped
    }

    /**
     * @param value The custom version of the content. A optional free text
     */
    @JvmName("rarlttudlmdjpsfg")
    public suspend fun customVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customVersion = mapped
    }

    /**
     * @param value Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex formats.
     */
    @JvmName("ybsbufemqadpikwg")
    public suspend fun dependencies(`value`: MetadataDependenciesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependencies = mapped
    }

    /**
     * @param argument Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex formats.
     */
    @JvmName("gesnountwhurtluo")
    public suspend fun dependencies(argument: suspend MetadataDependenciesArgsBuilder.() -> Unit) {
        val toBeMapped = MetadataDependenciesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dependencies = mapped
    }

    /**
     * @param value first publish date solution content item
     */
    @JvmName("dnlnyocbqhkoikst")
    public suspend fun firstPublishDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstPublishDate = mapped
    }

    /**
     * @param value the icon identifier. this id can later be fetched from the solution template
     */
    @JvmName("tcybfhmcwpqiueeg")
    public suspend fun icon(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.icon = mapped
    }

    /**
     * @param value The kind of content the metadata is for.
     */
    @JvmName("uwvvtfyolwitdfvf")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value last publish date for the solution content item
     */
    @JvmName("wrtyjxhlcxdrjoxv")
    public suspend fun lastPublishDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastPublishDate = mapped
    }

    /**
     * @param value The Metadata name.
     */
    @JvmName("lkgbtbcjmvplhqxo")
    public suspend fun metadataName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataName = mapped
    }

    /**
     * @param value Full parent resource ID of the content item the metadata is for.  This is the full resource ID including the scope (subscription and resource group)
     */
    @JvmName("fnwmmnwemckuokkx")
    public suspend fun parentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentId = mapped
    }

    /**
     * @param value preview image file names. These will be taken from the solution artifacts
     */
    @JvmName("ldhukjwuriaxhhoo")
    public suspend fun previewImages(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.previewImages = mapped
    }

    /**
     * @param values preview image file names. These will be taken from the solution artifacts
     */
    @JvmName("yjsyvlsrwdaqclwa")
    public suspend fun previewImages(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.previewImages = mapped
    }

    /**
     * @param value preview image file names. These will be taken from the solution artifacts. used for dark theme support
     */
    @JvmName("dayoelllxhukhlmm")
    public suspend fun previewImagesDark(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.previewImagesDark = mapped
    }

    /**
     * @param values preview image file names. These will be taken from the solution artifacts. used for dark theme support
     */
    @JvmName("chjxnhyshwibcwpi")
    public suspend fun previewImagesDark(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.previewImagesDark = mapped
    }

    /**
     * @param value Providers for the solution content item
     */
    @JvmName("yyisihgscevywysy")
    public suspend fun providers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providers = mapped
    }

    /**
     * @param values Providers for the solution content item
     */
    @JvmName("sxdfqpyxtpofwwnd")
    public suspend fun providers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providers = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nujlxmqktmuwhdoc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Source of the content.  This is where/how it was created.
     */
    @JvmName("fbstjybrtidqrrgd")
    public suspend fun source(`value`: MetadataSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument Source of the content.  This is where/how it was created.
     */
    @JvmName("qenkypftuaqsosct")
    public suspend fun source(argument: suspend MetadataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = MetadataSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value Support information for the metadata - type, name, contact information
     */
    @JvmName("jgdfndxowbtyyuvs")
    public suspend fun support(`value`: MetadataSupportArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.support = mapped
    }

    /**
     * @param argument Support information for the metadata - type, name, contact information
     */
    @JvmName("uktvamtocdnudmdr")
    public suspend fun support(argument: suspend MetadataSupportArgsBuilder.() -> Unit) {
        val toBeMapped = MetadataSupportArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.support = mapped
    }

    /**
     * @param value the tactics the resource covers
     */
    @JvmName("pqkeexaqmofwjptn")
    public suspend fun threatAnalysisTactics(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatAnalysisTactics = mapped
    }

    /**
     * @param values the tactics the resource covers
     */
    @JvmName("mnofucvnlqnwpmqt")
    public suspend fun threatAnalysisTactics(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatAnalysisTactics = mapped
    }

    /**
     * @param value the techniques the resource covers, these have to be aligned with the tactics being used
     */
    @JvmName("mtlmkdltlohcfdvd")
    public suspend fun threatAnalysisTechniques(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatAnalysisTechniques = mapped
    }

    /**
     * @param values the techniques the resource covers, these have to be aligned with the tactics being used
     */
    @JvmName("fpfishaswuophfpm")
    public suspend fun threatAnalysisTechniques(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatAnalysisTechniques = mapped
    }

    /**
     * @param value Version of the content.  Default and recommended format is numeric (e.g. 1, 1.0, 1.0.0, 1.0.0.0), following ARM template best practices.  Can also be any string, but then we cannot guarantee any version checks
     */
    @JvmName("hhdldhpdunucgpoo")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("sjaxwniiswcmoeps")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): MetadataArgs = MetadataArgs(
        author = author,
        categories = categories,
        contentId = contentId,
        contentSchemaVersion = contentSchemaVersion,
        customVersion = customVersion,
        dependencies = dependencies,
        firstPublishDate = firstPublishDate,
        icon = icon,
        kind = kind,
        lastPublishDate = lastPublishDate,
        metadataName = metadataName,
        parentId = parentId,
        previewImages = previewImages,
        previewImagesDark = previewImagesDark,
        providers = providers,
        resourceGroupName = resourceGroupName,
        source = source,
        support = support,
        threatAnalysisTactics = threatAnalysisTactics,
        threatAnalysisTechniques = threatAnalysisTechniques,
        version = version,
        workspaceName = workspaceName,
    )
}
